/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvas;

import java.awt.geom.Ellipse2D;
import ruplib.canvas.Canvas;
import ruplib.canvas.ICanvasShape;
import ruplib.geom.Area;
import ruplib.geom.Position;
import ruplib.geom.Size;
import ruplib.util.IColorable;
import ruplib.util.NamedColor;

public class Ellipse
implements ICanvasShape,
IColorable {
    public static final NamedColor DEFAULT_COLOR = NamedColor.BLUE;
    private static final Canvas CANVAS;
    private static int count;
    private final int ID = ++count;
    private String name = this.getClass().getSimpleName() + "_" + this.ID;
    private int xPos;
    private int yPos;
    protected int width;
    protected int height;
    private NamedColor color;

    public Ellipse() {
        this(0, 0, 2 * Canvas.getStep(), Canvas.getStep());
    }

    public Ellipse(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, DEFAULT_COLOR);
    }

    public Ellipse(int n, int n2, int n3, int n4, NamedColor namedColor) {
        if (n3 <= 0 || n4 <= 0 || namedColor == null) {
            throw new IllegalArgumentException("\nnew Ellipse: Parametry nemaj\u00ed povolen\u00e9 hodnoty: x=" + n + ", y=" + n2 + ", width=" + n3 + ", height=" + n4 + ", color=" + String.valueOf(namedColor));
        }
        this.color = namedColor;
        this.xPos = n;
        this.yPos = n2;
        this.width = n3;
        this.height = n4;
        this.paintPrivate();
    }

    public Ellipse(Position position, Size size, NamedColor namedColor) {
        this(position.x, position.y, size.width, size.height, namedColor);
    }

    public Ellipse(Area area, NamedColor namedColor) {
        this(area.x, area.y, area.width, area.height, namedColor);
    }

    @Override
    public final NamedColor getColor() {
        return this.color;
    }

    @Override
    public final void setColor(NamedColor namedColor) {
        this.color = namedColor;
        this.paint();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int getX() {
        return this.xPos;
    }

    @Override
    public int getY() {
        return this.yPos;
    }

    @Override
    public void setPosition(int n, int n2) {
        this.rubOut();
        this.xPos = n;
        this.yPos = n2;
        this.paint();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setSize(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("\nRozm\u011bry nesm\u011bj\u00ed b\u00fdt z\u00e1porn\u00e9: width=" + n + ", height=" + n2);
        }
        this.rubOut();
        this.width = n;
        this.height = n2;
        this.paint();
    }

    @Override
    public Ellipse copy() {
        if (this instanceof ICanvasShape) {
            return new Ellipse(this.xPos, this.yPos, this.width, this.height, this.color);
        }
        class TT
        extends Ellipse
        implements ICanvasShape {
            TT(Ellipse ellipse, int n, int n2, int n3, int n4, NamedColor namedColor) {
                super(n, n2, n3, n4, namedColor);
            }
        }
        return new TT(this, this.xPos, this.yPos, this.width, this.height, this.color);
    }

    public String toString() {
        return this.name + "[x=" + this.xPos + ", y=" + this.yPos + ", width=" + this.width + ", height=" + this.height + ", color=" + String.valueOf(this.color) + "]";
    }

    @Override
    public void paint() {
        this.paintPrivate();
    }

    @Override
    public final void rubOut() {
        CANVAS.erase(new Ellipse2D.Double(this.xPos, this.yPos, this.width, this.height));
    }

    private void paintPrivate() {
        CANVAS.fill(new Ellipse2D.Double(this.xPos, this.yPos, this.width, this.height), this.color);
    }

    static {
        count = 0;
        CANVAS = Canvas.getInstance();
    }
}

