/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvas;

import java.util.ArrayList;
import java.util.List;
import ruplib.canvas.ICanvasPaintable;
import ruplib.canvas.ICanvasShape;
import ruplib.geom.Direction8;
import ruplib.geom.IChangeable;
import ruplib.geom.IDirectable;

public class Multishape
implements ICanvasShape,
IDirectable {
    public static final Direction8 DEFAULT_DIRECTION = Direction8.NORTH;
    private static int count = 0;
    private final int ID = ++count;
    private final List<Part> parts = new ArrayList<Part>();
    private String name = this.getClass().getSimpleName() + "_" + this.ID;
    private boolean creationDone = false;
    private int xPos;
    private int yPos;
    protected int width;
    protected int height;
    private boolean copyable = true;
    private Direction8 direction;

    public Multishape() {
        this(null, new ICanvasShape[0]);
    }

    public Multishape(ICanvasShape iCanvasShape, ICanvasShape ... iCanvasShapeArray) {
        this(DEFAULT_DIRECTION, iCanvasShape, iCanvasShapeArray);
    }

    public Multishape(Direction8 direction8, ICanvasShape iCanvasShape, ICanvasShape ... iCanvasShapeArray) {
        this.setDirectionInternal(direction8);
        if (iCanvasShape != null) {
            this.addShapes(iCanvasShape);
            this.addShapes(iCanvasShapeArray);
            this.creationDone = true;
        }
    }

    public boolean isCopyable() {
        return this.copyable;
    }

    @Override
    public Direction8 getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(Direction8 direction8) {
        this.verifyDone();
        if (this.getWidth() != this.getHeight()) {
            throw new IllegalStateException("\nNastavovat sm\u011br je mo\u017eno pouze pro \u010dtvercov\u00fd mnohotvar: " + String.valueOf(this));
        }
        if (direction8 == this.direction) {
            return;
        }
        Direction8 direction82 = this.direction;
        this.setDirectionInternal(direction8);
        this.turnTo(direction8, direction82);
    }

    public void setInitialDirection(Direction8 direction8) {
        try {
            this.verifyDone();
        }
        catch (IllegalStateException illegalStateException) {
            this.setDirectionInternal(direction8);
            return;
        }
        throw new IllegalStateException("\nPo\u010d\u00e1te\u010dn\u00ed sm\u011br mnohotvaru lze nastavit pouzep\u0159ed jeho dokon\u010den\u00edm");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int getX() {
        return this.xPos;
    }

    @Override
    public int getY() {
        return this.yPos;
    }

    @Override
    public void setPosition(int n, int n2) {
        this.verifyDone();
        int n3 = n - this.getX();
        int n4 = n2 - this.getY();
        for (Part part : this.parts) {
            IChangeable iChangeable = part.changeable;
            iChangeable.setPosition(n3 + iChangeable.getX(), n4 + iChangeable.getY());
        }
        this.xPos = n;
        this.yPos = n2;
        this.paint();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setSize(int n, int n2) {
        this.verifyDone();
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("\nRozm\u011bry nesm\u011bj\u00ed b\u00fdt z\u00e1porn\u00e9: width=" + n + ", height=" + n2);
        }
        for (Part part : this.parts) {
            part.afterResizing(n, n2);
        }
        this.width = Math.max(1, n);
        this.height = Math.max(1, n2);
        this.paint();
    }

    public int getNumberOfShapes() {
        return this.parts.size();
    }

    public int getNumberOfSimpleShapes() {
        int n = 0;
        for (Part part : this.parts) {
            if (part.changeable instanceof Multishape) {
                n += ((Multishape)part.changeable).getNumberOfSimpleShapes();
                continue;
            }
            ++n;
        }
        return n;
    }

    public final void addShapes(ICanvasShape ... iCanvasShapeArray) {
        if (this.creationDone) {
            throw new IllegalStateException("\nAttempt to add a shape after finishing the creation of the mutlishape " + this.name);
        }
        for (ICanvasShape iCanvasShape : iCanvasShapeArray) {
            ICanvasShape iCanvasShape2 = iCanvasShape.copy();
            this.addTheShape(iCanvasShape2);
        }
    }

    public final void addTheShape(ICanvasShape iCanvasShape) {
        int n = iCanvasShape.getX();
        int n2 = iCanvasShape.getY();
        int n3 = iCanvasShape.getWidth();
        int n4 = iCanvasShape.getHeight();
        if (this.parts.isEmpty()) {
            this.xPos = n;
            this.yPos = n2;
            this.width = n3;
            this.height = n4;
            this.parts.add(new Part(iCanvasShape, iCanvasShape));
            return;
        }
        int n5 = this.xPos;
        int n6 = this.yPos;
        int n7 = this.width;
        int n8 = this.height;
        boolean bl = false;
        if (n < this.xPos) {
            this.width += this.getX() - n;
            this.xPos = n;
            bl = true;
        }
        if (n2 < this.yPos) {
            this.height += this.yPos - n2;
            this.yPos = n2;
            bl = true;
        }
        if (this.xPos + this.width < n + n3) {
            this.width = n + n3 - this.xPos;
            bl = true;
        }
        if (this.yPos + this.height < n2 + n4) {
            this.height = n2 + n4 - this.yPos;
            bl = true;
        }
        if (bl) {
            for (Part part : this.parts) {
                part.afterAddition(n5, n6, n7, n8);
            }
        }
        this.parts.add(new Part(iCanvasShape, iCanvasShape));
    }

    @Override
    public Multishape copy() {
        if (!this.copyable) {
            throw new IllegalStateException("\nDan\u00fd mnohotvar nen\u00ed kop\u00edrovateln\u00fd");
        }
        ICanvasShape[] iCanvasShapeArray = new ICanvasShape[this.parts.size() - 1];
        ICanvasShape iCanvasShape = (ICanvasShape)this.parts.get((int)0).changeable;
        for (int i = 0; i < iCanvasShapeArray.length; ++i) {
            Part part = this.parts.get(i + 1);
            iCanvasShapeArray[i] = (ICanvasShape)part.changeable;
        }
        Multishape multishape = new Multishape(iCanvasShape, iCanvasShapeArray);
        return multishape;
    }

    public void creationDone() {
        if (this.parts.size() < 1) {
            throw new IllegalStateException("\nThe multishape has to have at least one part");
        }
        this.creationDone = true;
    }

    @Override
    public void paint() {
        for (Part part : this.parts) {
            part.paintable.paint();
        }
    }

    @Override
    public void rubOut() {
        for (Part part : this.parts) {
            part.paintable.rubOut();
        }
    }

    public String toString() {
        return this.name + "[x=" + this.xPos + ", y=" + this.yPos + ", width=" + this.width + ", height=" + this.height + ", direction=" + String.valueOf((Object)this.direction) + ", ID=" + this.ID + "]";
    }

    private void setDirectionInternal(Direction8 direction8) {
        if (!direction8.isCardinal()) {
            throw new IllegalArgumentException("\nMnohotvar lze nato\u010dit pouze do jednoho ze \u010dty\u0159 hlavn\u00edch sm\u011br\u016f, po\u017eadov\u00e1no: " + String.valueOf((Object)direction8));
        }
        this.direction = direction8;
    }

    private void turnTo(Direction8 direction8, Direction8 direction82) {
        if (direction8 == Direction8.NOWHERE) {
            return;
        }
        Direction8[] direction8Array = null;
        int n = this.getWidth();
        int n2 = direction82.ordinalDistanceTo(direction8);
        for (Part part : this.parts) {
            double d;
            double d2;
            double d3;
            if (part.changeable instanceof IDirectable) {
                if (direction8Array == null) {
                    direction8Array = Direction8.values();
                }
                Direction8 direction83 = ((IDirectable)((Object)part.changeable)).getDirection();
                Direction8 direction84 = direction8Array[direction83.ordinal() + n2];
                ((IDirectable)((Object)part.changeable)).setDirection(direction84);
            }
            double d4 = switch (n2) {
                case -6, 2 -> {
                    d3 = part.dy;
                    d2 = 1.0 - part.dx - part.dw;
                    d = part.dh;
                    yield part.dw;
                }
                case -4, 4 -> {
                    d3 = 1.0 - part.dx - part.dw;
                    d2 = 1.0 - part.dy - part.dh;
                    d = part.dw;
                    yield part.dh;
                }
                case -2, 6 -> {
                    d3 = 1.0 - part.dy - part.dh;
                    d2 = part.dx;
                    d = part.dh;
                    yield part.dw;
                }
                default -> throw new RuntimeException("\nNen\u00ed mo\u017en\u00e9 oto\u010dit oblast ze sm\u011bru " + String.valueOf((Object)direction82) + " do sm\u011bru " + String.valueOf(this));
            };
            part.dx = d3;
            part.dy = d2;
            part.dw = d;
            part.dh = d4;
            part.afterResizing(n, n);
        }
    }

    private void verifyDone() {
        if (this.creationDone) {
            return;
        }
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string = stackTraceElementArray[1].getMethodName();
        throw new IllegalStateException("\nNedokon\u010den\u00fd tvar nem\u016f\u017ee volat metodu: " + string);
    }

    private final class Part {
        IChangeable changeable;
        ICanvasPaintable paintable;
        double dx;
        double dy;
        double dw;
        double dh;

        Part(IChangeable iChangeable, ICanvasPaintable iCanvasPaintable) {
            this.changeable = iChangeable;
            this.paintable = iCanvasPaintable;
            int n = iChangeable.getX();
            int n2 = iChangeable.getY();
            int n3 = iChangeable.getWidth();
            int n4 = iChangeable.getHeight();
            this.dx = (double)(n - Multishape.this.xPos) / (double)Multishape.this.width;
            this.dy = (double)(n2 - Multishape.this.yPos) / (double)Multishape.this.height;
            this.dw = (double)n3 / (double)Multishape.this.width;
            this.dh = (double)n4 / (double)Multishape.this.height;
        }

        void afterAddition(int n, int n2, int n3, int n4) {
            this.dx = ((double)(n - Multishape.this.xPos) + this.dx * (double)n3) / (double)Multishape.this.width;
            this.dy = ((double)(n2 - Multishape.this.yPos) + this.dy * (double)n4) / (double)Multishape.this.height;
            this.dw = this.dw * (double)n3 / (double)Multishape.this.width;
            this.dh = this.dh * (double)n4 / (double)Multishape.this.height;
        }

        void afterResizing(int n, int n2) {
            this.changeable.setPosition((int)Math.round((double)Multishape.this.xPos + this.dx * (double)n), (int)Math.round((double)Multishape.this.yPos + this.dy * (double)n2));
            this.changeable.setSize((int)Math.round(this.dw * (double)n), (int)Math.round(this.dh * (double)n2));
        }

        public String toString() {
            return "Part[shape=" + String.valueOf(this.changeable) + ", dx=" + this.dx + ", dy=" + this.dy + ", dw=" + this.dw + ", dh=" + this.dh + "]";
        }
    }
}

