/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvas;

import java.awt.Polygon;
import ruplib.canvas.Canvas;
import ruplib.canvas.ICanvasShape;
import ruplib.geom.Area;
import ruplib.geom.Direction8;
import ruplib.geom.IDirectable;
import ruplib.geom.Position;
import ruplib.geom.Size;
import ruplib.util.IColorable;
import ruplib.util.NamedColor;

public class Triangle
implements ICanvasShape,
IColorable,
IDirectable {
    public static final NamedColor DEFAULT_COLOR = NamedColor.GREEN;
    public static final Direction8 DEFAULT_DIRECTION = Direction8.NORTH;
    private static final Canvas CANVAS;
    private static int count;
    private final int ID = ++count;
    private final int[] xPoints = new int[3];
    private final int[] yPoints = new int[3];
    private String name = this.getClass().getSimpleName() + "_" + this.ID;
    private int xPos;
    private int yPos;
    protected int width;
    protected int height;
    private NamedColor color;
    private Direction8 dir8;

    public Triangle() {
        this(0, 0, 2 * Canvas.getStep(), Canvas.getStep());
    }

    public Triangle(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, DEFAULT_COLOR, DEFAULT_DIRECTION);
    }

    public Triangle(int n, int n2, int n3, int n4, NamedColor namedColor) {
        this(n, n2, n3, n4, namedColor, DEFAULT_DIRECTION);
    }

    public Triangle(int n, int n2, int n3, int n4, Direction8 direction8) {
        this(n, n2, n3, n4, DEFAULT_COLOR, direction8);
    }

    public Triangle(int n, int n2, int n3, int n4, NamedColor namedColor, Direction8 direction8) {
        if (n3 <= 0 || n4 <= 0 || namedColor == null || direction8 == null || direction8 == Direction8.NOWHERE) {
            throw new IllegalArgumentException("\nnew Triangle: Parametry nemaj\u00ed povolen\u00e9 hodnoty: x=" + n + ", y=" + n2 + ", width=" + n3 + ", height=" + n4 + ", color=" + String.valueOf(namedColor) + ", direction=" + String.valueOf((Object)direction8));
        }
        this.xPos = n;
        this.yPos = n2;
        this.width = n3;
        this.height = n4;
        this.color = namedColor;
        this.dir8 = direction8;
        this.paintPrivate();
    }

    public Triangle(Position position, Size size, NamedColor namedColor, Direction8 direction8) {
        this(position.x, position.y, size.width, size.height, namedColor, direction8);
    }

    public Triangle(Area area, NamedColor namedColor, Direction8 direction8) {
        this(area.x, area.y, area.width, area.height, namedColor, direction8);
    }

    @Override
    public final NamedColor getColor() {
        return this.color;
    }

    @Override
    public final void setColor(NamedColor namedColor) {
        this.color = namedColor;
        this.paint();
    }

    @Override
    public final Direction8 getDirection() {
        return this.dir8;
    }

    @Override
    public final void setDirection(Direction8 direction8) {
        assert (direction8 != Direction8.NOWHERE) : "Troj\u00faheln\u00edk mus\u00ed b\u00fdt nato\u010den do n\u011bkter\u00e9ho z \u0159\u00e1dn\u00fdch sm\u011br\u016f";
        if (direction8 != this.dir8) {
            NamedColor namedColor = this.color;
            this.rubOut();
            this.dir8 = direction8;
            this.paint();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public int getX() {
        return this.xPos;
    }

    @Override
    public int getY() {
        return this.yPos;
    }

    @Override
    public void setPosition(int n, int n2) {
        this.rubOut();
        this.xPos = n;
        this.yPos = n2;
        this.paint();
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setSize(int n, int n2) {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("\nRozm\u011bry nesm\u011bj\u00ed b\u00fdt z\u00e1porn\u00e9: width=" + n + ", height=" + n2);
        }
        this.rubOut();
        this.width = n;
        this.height = n2;
        this.paint();
    }

    @Override
    public Triangle copy() {
        if (this instanceof ICanvasShape) {
            return new Triangle(this.xPos, this.yPos, this.width, this.height, this.color, this.dir8);
        }
        class TT
        extends Triangle
        implements ICanvasShape {
            TT(Triangle triangle, int n, int n2, int n3, int n4, NamedColor namedColor, Direction8 direction8) {
                super(n, n2, n3, n4, namedColor, direction8);
            }
        }
        return new TT(this, this.xPos, this.yPos, this.width, this.height, this.color, this.dir8);
    }

    public String toString() {
        return this.name + "[x=" + this.xPos + ", y=" + this.yPos + ", width=" + this.width + ", height=" + this.height + ", color=" + String.valueOf(this.color) + ", direction=" + String.valueOf((Object)this.dir8) + "]";
    }

    @Override
    public void paint() {
        this.paintPrivate();
    }

    @Override
    public final void rubOut() {
        int[][] nArray = this.getVertexes();
        CANVAS.erase(new Polygon(nArray[0], nArray[1], 3));
    }

    private void paintPrivate() {
        int[][] nArray = this.getVertexes();
        CANVAS.fill(new Polygon(nArray[0], nArray[1], 3), this.color);
    }

    private int[][] getVertexes() {
        int[] nArray = null;
        int[] nArray2 = null;
        switch (this.dir8) {
            case EAST: {
                nArray = new int[]{this.xPos, this.xPos + this.width, this.xPos};
                nArray2 = new int[]{this.yPos, this.yPos + this.height / 2, this.yPos + this.height};
                break;
            }
            case NORTH_EAST: {
                nArray = new int[]{this.xPos, this.xPos + this.width, this.xPos + this.width};
                nArray2 = new int[]{this.yPos, this.yPos, this.yPos + this.height};
                break;
            }
            case NORTH: {
                nArray = new int[]{this.xPos, this.xPos + this.width / 2, this.xPos + this.width};
                nArray2 = new int[]{this.yPos + this.height, this.yPos, this.yPos + this.height};
                break;
            }
            case NORTH_WEST: {
                nArray = new int[]{this.xPos, this.xPos, this.xPos + this.width};
                nArray2 = new int[]{this.yPos + this.height, this.yPos, this.yPos};
                break;
            }
            case WEST: {
                nArray = new int[]{this.xPos, this.xPos + this.width, this.xPos + this.width};
                nArray2 = new int[]{this.yPos + this.height / 2, this.yPos, this.yPos + this.height};
                break;
            }
            case SOUTH_WEST: {
                nArray = new int[]{this.xPos, this.xPos, this.xPos + this.width};
                nArray2 = new int[]{this.yPos, this.yPos + this.height, this.yPos + this.height};
                break;
            }
            case SOUTH: {
                nArray = new int[]{this.xPos, this.xPos + this.width / 2, this.xPos + this.width};
                nArray2 = new int[]{this.yPos, this.yPos + this.height, this.yPos};
                break;
            }
            case SOUTH_EAST: {
                nArray = new int[]{this.xPos, this.xPos + this.width, this.xPos + this.width};
                nArray2 = new int[]{this.yPos + this.height, this.yPos + this.height, this.yPos};
                break;
            }
            default: {
                throw new IllegalStateException("Instance points to a no existing direction");
            }
        }
        return new int[][]{nArray, nArray2};
    }

    static {
        count = 0;
        CANVAS = Canvas.getInstance();
    }
}

