/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvasmanager;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import ruplib.canvasmanager.CanvasManager;
import ruplib.canvasmanager.IMultimovable;
import ruplib.geom.IMovable;
import ruplib.geom.Position;

public class Multimover {
    private static final int PERIOD_0 = 50;
    private static final CanvasManager CM = CanvasManager.getInstance(false);
    private static final Multimover singleton = new Multimover();
    private final Timer timer = new Timer();
    private final int period = 50;
    private final Map<IMovable, Animation> movable2animation = new LinkedHashMap<IMovable, Animation>();
    private final Set<Map.Entry<IMovable, Animation>> couples = this.movable2animation.entrySet();
    private Multimove multimove = null;

    public static Multimover getInstance() {
        return singleton;
    }

    private Multimover() {
    }

    public double getFrequency() {
        return 20.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMovable[] getMoved() {
        Map<IMovable, Animation> map = this.movable2animation;
        synchronized (map) {
            return this.movable2animation.keySet().toArray(new IMovable[0]);
        }
    }

    public int getPeriod() {
        return 50;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMoving(IMovable iMovable) {
        Map<IMovable, Animation> map = this.movable2animation;
        synchronized (map) {
            return this.movable2animation.containsKey(iMovable);
        }
    }

    public void moveInTime(double d, IMovable iMovable, Position position) {
        this.moveInTime(d, iMovable, position.x, position.y);
    }

    public void moveInTime(double d, IMovable iMovable, int n, int n2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("Doba p\u0159esunu mus\u00ed b\u00fdt kladn\u00e1!");
        }
        this.moveInternal(iMovable, n, n2, 0, d * 1000.0);
    }

    public void moveWithSpeed(int n, IMovable iMovable, Position position) {
        this.moveWithSpeed(n, iMovable, position.x, position.y);
    }

    public void moveWithSpeed(int n, IMovable iMovable, int n2, int n3) {
        if (n <= 0) {
            throw new IllegalArgumentException("Rychlost p\u0159esunu mus\u00ed b\u00fdt kladn\u00e1!");
        }
        this.moveInternal(iMovable, n2, n3, n, 0.0);
    }

    public void moveInTime(double d, IMovable iMovable, Position position, Consumer<IMovable> consumer) {
        this.moveInTime(d, iMovable, position.x, position.y, consumer);
    }

    public void moveInTime(double d, IMovable iMovable, int n, int n2, Consumer<IMovable> consumer) {
        this.moveInternal(iMovable, n, n2, 0, d * 1000.0, consumer);
    }

    public void moveWithSpeed(int n, IMovable iMovable, Position position, Consumer<IMovable> consumer) {
        this.moveWithSpeed(n, iMovable, position.x, position.y, consumer);
    }

    public void moveWithSpeed(int n, IMovable iMovable, int n2, int n3, Consumer<IMovable> consumer) {
        if (n <= 0) {
            throw new IllegalArgumentException("Rychlost p\u0159esunu mus\u00ed b\u00fdt kladn\u00e1!");
        }
        this.moveInternal(iMovable, n2, n3, n, 0.0, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop(IMovable iMovable) {
        Map<IMovable, Animation> map = this.movable2animation;
        synchronized (map) {
            if (this.movable2animation.containsKey(iMovable)) {
                this.movable2animation.remove(iMovable);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll() {
        this.stop();
        Map<IMovable, Animation> map = this.movable2animation;
        synchronized (map) {
            this.movable2animation.clear();
        }
    }

    private void moveInternal(IMovable iMovable2, int n, int n2, int n3, double d) {
        Consumer<IMovable> consumer = iMovable2 instanceof IMultimovable ? iMovable -> ((IMultimovable)iMovable).moved() : iMovable -> {};
        this.moveInternal(iMovable2, n, n2, n3, d, consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveInternal(IMovable iMovable, int n, int n2, int n3, double d, Consumer<IMovable> consumer) {
        if (iMovable == null) {
            throw new NullPointerException("P\u0159esouvan\u00fd objekt nesm\u00ed b\u00fdt null!");
        }
        Animation animation = new Animation(this, iMovable, n, n2, n3, d, consumer);
        Map<IMovable, Animation> map = this.movable2animation;
        synchronized (map) {
            if (this.movable2animation.get(iMovable) != null) {
                throw new IllegalStateException("P\u0159id\u00e1van\u00fd objekt ji\u017e je mezi p\u0159esouvan\u00fdmi!");
            }
            this.movable2animation.put(iMovable, animation);
            this.start();
        }
    }

    private synchronized void stop() {
        if (this.multimove == null) {
            return;
        }
        this.multimove.cancel();
        this.multimove = null;
    }

    private synchronized void start() {
        if (this.multimove == null) {
            this.multimove = new Multimove();
            this.timer.scheduleAtFixedRate((TimerTask)this.multimove, 50L, 50L);
        }
    }

    private class Multimove
    extends TimerTask {
        Multimove() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Map<IMovable, Animation> map = Multimover.this.movable2animation;
            synchronized (map) {
                Iterator<Map.Entry<IMovable, Animation>> iterator = Multimover.this.couples.iterator();
                CM.stopPainting();
                while (iterator.hasNext()) {
                    final Animation animation = iterator.next().getValue();
                    animation.x += animation.dx;
                    animation.y += animation.dy;
                    animation.object.setPosition((int)animation.x, (int)animation.y);
                    if (--animation.numSteps != 0) continue;
                    animation.object.setPosition(animation.xt, animation.yt);
                    iterator.remove();
                    Thread thread = new Thread(this, animation.toString()){

                        @Override
                        public void run() {
                            animation.whenMoved.accept(animation.object);
                        }
                    };
                    thread.start();
                }
                if (Multimover.this.movable2animation.size() <= 0) {
                    Multimover.this.stop();
                }
                CM.returnPainting();
            }
        }
    }

    private class Animation {
        double x;
        double y;
        double dx;
        double dy;
        IMovable object;
        int xt;
        int yt;
        int numSteps;
        Consumer<IMovable> whenMoved;

        Animation(Multimover multimover, IMovable iMovable, int n, int n2, int n3, double d, Consumer<IMovable> consumer) {
            this.object = iMovable;
            this.xt = n;
            this.yt = n2;
            this.whenMoved = consumer;
            Position position = iMovable.getPosition();
            this.dx = n - position.x;
            this.dy = n2 - position.y;
            if (n3 > 0) {
                double d2 = Math.hypot(this.dx, this.dy);
                this.numSteps = (int)(1000.0 * d2 / (double)(n3 * 50));
            } else {
                this.numSteps = (int)(d / 50.0);
            }
            if (this.numSteps < 1) {
                this.numSteps = 1;
            }
            this.x = (double)position.x + 0.4;
            this.y = (double)position.y + 0.4;
            this.dx /= (double)this.numSteps;
            this.dy /= (double)this.numSteps;
        }
    }
}

