/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvasmanager;

import java.awt.Font;
import ruplib.canvasmanager.ICMPaintable;
import ruplib.canvasmanager.Painter;
import ruplib.geom.IMovable;
import ruplib.geom.Position;
import ruplib.util.IColorable;
import ruplib.util.ICopyable;
import ruplib.util.NamedColor;

public class Text
implements IMovable,
ICopyable,
IColorable,
ICMPaintable {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final NamedColor DEFAULT_COLOR = NamedColor.BLACK;
    private static int count = 0;
    private final int ID = ++count;
    private final String text;
    private String name = "Text_" + this.ID;
    private int xPos;
    private int yPos;
    private NamedColor color;
    private Font font;
    private Font painterFont;

    public Text(String string) {
        this(string, 0, 0);
    }

    public Text(String string, int n, int n2) {
        this(n, n2, DEFAULT_COLOR, string);
    }

    public Text(int n, int n2, String string) {
        this(n, n2, DEFAULT_COLOR, string);
    }

    public Text(Position position, String string) {
        this(position.x, position.y, string);
    }

    public Text(Position position, NamedColor namedColor, String string) {
        this(position.x, position.y, namedColor, string);
    }

    public Text(int n, int n2, NamedColor namedColor, String string) {
        this.xPos = n;
        this.yPos = n2;
        this.text = string;
        this.color = namedColor;
        this.font = new Font("Dialog", 1, 12);
    }

    @Override
    public NamedColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(NamedColor namedColor) {
        this.color = namedColor;
        CM.repaint();
    }

    public String getName() {
        return this.text;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(String string, int n, int n2) {
        this.font = new Font(string, n, n2);
    }

    @Override
    public int getX() {
        return this.xPos;
    }

    @Override
    public int getY() {
        return this.yPos;
    }

    @Override
    public void setPosition(int n, int n2) {
        this.xPos = n;
        this.yPos = n2;
        CM.repaint();
    }

    @Override
    public Text copy() {
        Text text = new Text(this.xPos, this.yPos, this.color, this.name);
        text.font = this.font;
        text.painterFont = this.painterFont;
        return text;
    }

    @Override
    public void paint(Painter painter) {
        if (this.font != this.painterFont) {
            painter.setFont(this.font);
            this.painterFont = this.font;
        }
        painter.drawText(this.name, this.xPos, this.yPos + this.font.getSize(), this.color);
    }

    public String toString() {
        return this.name + "[x=" + this.xPos + ", y=" + this.yPos + ", color=" + String.valueOf(this.color) + ", font=" + String.valueOf(this.font) + ", text=" + this.text + "]";
    }
}

