/*
 * Decompiled with CFR 0.152.
 */
package ruplib.dbg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import ruplib.dbg.IndentingPrintStream;

public final class DBG {
    private static final Map<OutputStream, IndentingPrintStream> OUTPUT_2_INDENTING_STREAM = new HashMap<OutputStream, IndentingPrintStream>();
    public static int DEBUG_LEVEL = 1;

    public static int getDEBUG_LEVEL() {
        return DEBUG_LEVEL;
    }

    public static void setDEBUG_LEVEL(int n) {
        DEBUG_LEVEL = n;
    }

    public static Collection<IndentingPrintStream> getOutputStreams() {
        return OUTPUT_2_INDENTING_STREAM.values();
    }

    public static IndentingPrintStream getWrapperOf(PrintStream printStream) {
        return OUTPUT_2_INDENTING_STREAM.get(printStream);
    }

    public static IndentingPrintStream addOutputStream(OutputStream outputStream) {
        if (OUTPUT_2_INDENTING_STREAM.containsKey(outputStream)) {
            return null;
        }
        IndentingPrintStream indentingPrintStream = IndentingPrintStream.indentifyPrintStream(outputStream);
        OUTPUT_2_INDENTING_STREAM.put(outputStream, indentingPrintStream);
        return indentingPrintStream;
    }

    public static void addOutputStream(String string) {
        switch (string) {
            case "out": {
                DBG.addOutputStream(System.out);
                break;
            }
            case "err": {
                DBG.addOutputStream(System.err);
                break;
            }
            default: {
                File file = new File(string);
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    DBG.addOutputStream(fileOutputStream);
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("\nSoubor " + String.valueOf(file) + " se nepoda\u0159ilo naj\u00edt ani vytvo\u0159it", iOException);
                }
            }
        }
    }

    public static boolean removeOutputStream(OutputStream outputStream) {
        IndentingPrintStream indentingPrintStream = OUTPUT_2_INDENTING_STREAM.remove(outputStream);
        return indentingPrintStream != null;
    }

    public static void pr(Object object) {
        if (DEBUG_LEVEL > 0) {
            DBG.print(object);
        }
    }

    public static void pr(int n, Object object) {
        if (DEBUG_LEVEL >= n) {
            DBG.print(object);
        }
    }

    public static void prf(String string, Object ... objectArray) {
        if (DEBUG_LEVEL > 0) {
            DBG.printf(string, objectArray);
        }
    }

    public static void prf(int n, String string, Object ... objectArray) {
        if (DEBUG_LEVEL >= n) {
            DBG.printf(string, objectArray);
        }
    }

    public static void prln(Object object) {
        if (DEBUG_LEVEL > 0) {
            DBG.println(object);
        }
    }

    public static void prln(int n, Object object) {
        if (DEBUG_LEVEL >= n) {
            DBG.println(object);
        }
    }

    public static void prNln(String string, Object[] objectArray) {
        DBG.prNln(-1, string, objectArray);
    }

    public static void prNln(int n, String string, Object[] objectArray) {
        DBG.prNln(n, string, Arrays.stream(objectArray));
    }

    public static void prNln(String string, Collection<?> collection) {
        DBG.prNln(-1, string, collection);
    }

    public static void prNln(int n, String string, Collection<?> collection) {
        DBG.prNln(n, string, collection.stream());
    }

    public static void prNln(String string, Stream<?> stream) {
        DBG.prNln(-1, string, stream);
    }

    public static void prNln(int n, String string, Stream<?> stream) {
        if (DEBUG_LEVEL >= n) {
            StringBuilder stringBuilder = new StringBuilder(string).append(": ");
            stream.forEachOrdered(object -> stringBuilder.append('\n').append(object));
            stringBuilder.append('\n');
            DBG.println(stringBuilder.toString());
        }
    }

    public static String stackTrace(Throwable throwable) {
        StringBuilder stringBuilder = new StringBuilder(512);
        while (throwable != null) {
            StackTraceElement[] stackTraceElementArray;
            stringBuilder.append(throwable).append('\n');
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                stringBuilder.append("\tat ").append(stackTraceElement).append('\n');
            }
            if ((throwable = throwable.getCause()) == null) continue;
            stringBuilder.append("\nCaused by\n");
        }
        return stringBuilder.toString();
    }

    public static void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private static void print(Object object) {
        DBG.printf("%s", object);
    }

    private static void printf(String string, Object ... objectArray) {
        OUTPUT_2_INDENTING_STREAM.values().stream().forEachOrdered(indentingPrintStream -> {
            indentingPrintStream.printf(string, objectArray);
            indentingPrintStream.flush();
        });
    }

    private static void println(Object object) {
        DBG.printf("%s\n", object);
    }

    private DBG() {
    }

    static {
        DBG.addOutputStream(System.out);
    }
}

