/*
 * Decompiled with CFR 0.152.
 */
package ruplib.dbg;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.function.Consumer;
import ruplib.dbg.CallerReporter;
import ruplib.dbg.IndentingPrintStream;

public class IndentingReporter
extends IndentingPrintStream {
    private static volatile IndentingReporter systemReporter = null;

    public static IndentingReporter getSensitiveSystemReporter() {
        IndentingReporter.setThreadSensitive(true);
        return IndentingReporter.getSystemReporter();
    }

    public static IndentingReporter getSystemReporter() {
        if (systemReporter == null) {
            systemReporter = IndentingReporter.getInstance(System.out);
            IndentingReporter.setSystemOut(systemReporter);
        }
        return systemReporter;
    }

    public static IndentingReporter getSystemReporter(String string) {
        if (systemReporter == null) {
            systemReporter = IndentingReporter.getInstance(System.out, string);
            IndentingReporter.setSystemOut(systemReporter);
        }
        return systemReporter;
    }

    public static String getCallerName() {
        String string = CallerReporter.getCallerName(CallerReporter.Level.CLASS, 1);
        return string;
    }

    public static IndentingReporter getInstance(OutputStream outputStream) {
        return IndentingReporter.getInstance(outputStream, "windows-1250");
    }

    public static IndentingReporter getInstance(OutputStream outputStream, String string) {
        IndentingReporter indentingReporter;
        try {
            indentingReporter = new IndentingReporter(outputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("\nZadan\u00e1 k\u00f3dov\u00e1 str\u00e1nka nen\u00ed podporov\u00e1na: " + string, unsupportedEncodingException);
        }
        return indentingReporter;
    }

    public IndentingReporter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream, string);
    }

    public IndentingReporter reportStart() {
        return this.reportStart(1, (String)null);
    }

    public IndentingReporter reportEnd() {
        return this.reportEnd(1, (String)null);
    }

    public IndentingReporter reportStart(String string) {
        return this.reportStart(1, string);
    }

    public IndentingReporter reportEnd(String string) {
        return this.reportEnd(1, string);
    }

    public IndentingReporter reportStart(int n, String string) {
        String string2 = "START: " + CallerReporter.getCallerName(CallerReporter.Level.CLASS, n + 1);
        this.append(string2).indent();
        if (string != null) {
            this.append(string);
            this.append('\n');
        }
        return this;
    }

    public IndentingReporter reportEnd(int n, String string) {
        if (string != null) {
            this.append(string);
        }
        String string2 = "END: " + CallerReporter.getCallerName(CallerReporter.Level.CLASS, n + 1);
        this.outdent().append(string2).append('\n');
        return this;
    }

    public IndentingReporter reportStart(Consumer<IndentingReporter> consumer) {
        return this.reportStart(1, consumer);
    }

    public IndentingReporter reportEnd(Consumer<IndentingReporter> consumer) {
        return this.reportEnd(1, consumer);
    }

    public IndentingReporter reportStart(int n, Consumer<IndentingReporter> consumer) {
        String string = CallerReporter.getCallerName(CallerReporter.Level.CLASS, n + 1);
        this.append(string).indent();
        consumer.accept(this);
        return this;
    }

    public IndentingReporter reportEnd(int n, Consumer<IndentingReporter> consumer) {
        String string = CallerReporter.getCallerName(CallerReporter.Level.CLASS, n + 1);
        consumer.accept(this);
        this.outdent().append(string).append('\n');
        return this;
    }

    public IndentingReporter report(String string) {
        this.append(string);
        return this;
    }

    public IndentingReporter reportln(String string) {
        this.append(string).append('\n');
        return this;
    }

    @Override
    public IndentingReporter append(CharSequence charSequence) {
        super.append(charSequence);
        return this;
    }

    @Override
    public IndentingReporter append(CharSequence charSequence, int n, int n2) {
        super.append(charSequence, n, n2);
        return this;
    }

    @Override
    public IndentingReporter append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public IndentingReporter format(String string, Object ... objectArray) {
        super.format(string, objectArray);
        return this;
    }

    @Override
    public IndentingReporter format(Locale locale, String string, Object ... objectArray) {
        super.format(locale, string, objectArray);
        return this;
    }

    @Override
    public IndentingReporter indent() {
        super.indent();
        return this;
    }

    @Override
    public IndentingReporter outdent() {
        super.outdent();
        return this;
    }

    @Override
    public IndentingReporter printf(String string, Object ... objectArray) {
        super.printf(string, objectArray);
        return this;
    }

    @Override
    public IndentingReporter printf(Locale locale, String string, Object ... objectArray) {
        super.printf(locale, string, objectArray);
        return this;
    }
}

