/*
 * Decompiled with CFR 0.152.
 */
package ruplib.dbg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import ruplib.dbg.DBG;
import ruplib.dbg.IndentingPrintStream;

public final class Printer {
    private static final Map<OutputStream, IndentingPrintStream> OUTPUT_2_INDENTING_STREAM = new HashMap<OutputStream, IndentingPrintStream>();
    public static int DEBUG_LEVEL = 0;

    public static int getDEBUG_LEVEL() {
        return DEBUG_LEVEL;
    }

    public static void setDEBUG_LEVEL(int n) {
        DBG.DEBUG_LEVEL = n;
    }

    public static Collection<OutputStream> getOutputStreams() {
        return OUTPUT_2_INDENTING_STREAM.keySet();
    }

    public static boolean addOutputStream(OutputStream outputStream) {
        if (OUTPUT_2_INDENTING_STREAM.containsKey(outputStream)) {
            return false;
        }
        IndentingPrintStream indentingPrintStream = IndentingPrintStream.indentifyPrintStream(outputStream);
        OUTPUT_2_INDENTING_STREAM.put(outputStream, indentingPrintStream);
        return true;
    }

    public static void addOutputStream(String string) {
        switch (string) {
            case "out": {
                Printer.addOutputStream(System.out);
                break;
            }
            case "err": {
                Printer.addOutputStream(System.err);
                break;
            }
            default: {
                File file = new File(string);
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    Printer.addOutputStream(fileOutputStream);
                    break;
                }
                catch (IOException iOException) {
                    throw new RuntimeException("\nSoubor " + String.valueOf(file) + " se nepoda\u0159ilo naj\u00edt ani vytvo\u0159it", iOException);
                }
            }
        }
    }

    public static boolean removeOutputStream(OutputStream outputStream) {
        IndentingPrintStream indentingPrintStream = OUTPUT_2_INDENTING_STREAM.remove(outputStream);
        return indentingPrintStream != null;
    }

    public static void pr(String string) {
        if (DEBUG_LEVEL > 0) {
            Printer.print(string);
        }
    }

    public static void pr(int n, String string) {
        if (DEBUG_LEVEL >= n) {
            Printer.print(string);
        }
    }

    public static void prf(String string, Object ... objectArray) {
        if (DEBUG_LEVEL > 0) {
            Printer.printf(string, objectArray);
        }
    }

    public static void prf(int n, String string, Object ... objectArray) {
        if (DEBUG_LEVEL >= n) {
            Printer.printf(string, objectArray);
        }
    }

    public static void prln(String string) {
        if (DEBUG_LEVEL > 0) {
            Printer.println(string);
        }
    }

    public static void prln(int n, String string) {
        if (DEBUG_LEVEL >= n) {
            Printer.println(string);
        }
    }

    public static void prNln(String string, Object[] objectArray) {
        Printer.prNln(-1, string, objectArray);
    }

    public static void prNln(int n, String string, Object[] objectArray) {
        Printer.prNln(n, string, Arrays.stream(objectArray));
    }

    public static void prNln(String string, Collection<?> collection) {
        Printer.prNln(-1, string, collection);
    }

    public static void prNln(int n, String string, Collection<?> collection) {
        Printer.prNln(n, string, collection.stream());
    }

    public static void prNln(String string, Stream<?> stream) {
        Printer.prNln(-1, string, stream);
    }

    public static void prNln(int n, String string, Stream<?> stream) {
        if (DEBUG_LEVEL >= n) {
            StringBuilder stringBuilder = new StringBuilder(string).append(": ");
            stream.forEachOrdered(object -> stringBuilder.append('\n').append(object));
            stringBuilder.append('\n');
            Printer.println(stringBuilder.toString());
        }
    }

    public static void wait(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    private static void print(String string) {
        Printer.printf("%s", string);
    }

    private static void printf(String string, Object ... objectArray) {
        OUTPUT_2_INDENTING_STREAM.values().stream().forEachOrdered(indentingPrintStream -> {
            indentingPrintStream.printf(string, objectArray);
            indentingPrintStream.flush();
        });
    }

    private static void println(String string) {
        Printer.printf("%s\n", string);
    }

    private Printer() {
    }

    static {
        Printer.addOutputStream(System.out);
    }
}

