/*
 * Decompiled with CFR 0.152.
 */
package ruplib.dbg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ThreadMessages {
    private static final String INDENT = "> ";
    private static final long TIME = System.currentTimeMillis();
    private static final List<String> gap = new ArrayList<String>();
    private static final ThreadInfo threadInfo = new ThreadInfo();
    private static Character[] threadSigns = new Character[]{Character.valueOf('-'), Character.valueOf('+'), Character.valueOf('#'), Character.valueOf('*'), Character.valueOf('='), Character.valueOf('?')};
    private static int threadCount = 0;

    public static void setThreadSigns(Character[] characterArray) {
        threadSigns = characterArray;
    }

    public static synchronized void msgS(String string) {
        Info info = (Info)threadInfo.get();
        ThreadMessages.msg("Started:  " + string, info);
        int n = info.level + 1;
        if (n >= gap.size()) {
            gap.add(gap.get(n - 1) + INDENT);
        }
        info.level = n;
    }

    public static synchronized void msgF(String string) {
        Info info = (Info)threadInfo.get();
        --info.level;
        ThreadMessages.msg("Finished: " + string, info);
    }

    public static synchronized void msg(String string) {
        Info info = (Info)threadInfo.get();
        ThreadMessages.msg(string, info);
    }

    private ThreadMessages() {
    }

    private static synchronized void msg(String string, Info info) {
        double d = (double)(System.currentTimeMillis() - TIME) / 1000.0;
        System.out.printf("%8.3f %c %s%s%n", d, info.sign, gap.get(info.level), string);
        d = 0.0;
    }

    static {
        gap.add("");
    }

    private static class ThreadInfo
    extends ThreadLocal<Info> {
        private static final Set<Thread> threadSet = new HashSet<Thread>();

        private ThreadInfo() {
        }

        @Override
        protected final Info initialValue() {
            Thread thread = Thread.currentThread();
            if (threadSet.contains(thread)) {
                throw new IllegalStateException("\nThread variable for the current thread is already initialized - thread: " + String.valueOf(thread));
            }
            int n = threadSet.size();
            Info info = new Info(n, thread);
            threadSet.add(thread);
            return info;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Removing this variables is not allowed");
        }

        @Override
        public void set(Info info) {
            throw new UnsupportedOperationException("Setting into this variables is not allowed");
        }
    }

    private static class Info {
        private final int id;
        private final Thread thread;
        private final Character sign;
        private int level;

        private Info(int n, Thread thread) {
            this.id = n;
            this.thread = Thread.currentThread();
            this.sign = threadSigns[n];
            this.level = 0;
        }
    }
}

