/*
 * Decompiled with CFR 0.152.
 */
package ruplib.geom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ruplib.geom.Area;
import ruplib.geom.ITurnable4;
import ruplib.geom.ITurnable8;
import ruplib.geom.Position;

public enum Direction8 {
    EAST("E", 1, 0),
    NORTH_EAST("NE", 1, -1),
    NORTH("N", 0, -1),
    NORTH_WEST("NW", -1, -1),
    WEST("W", -1, 0),
    SOUTH_WEST("SW", -1, 1),
    SOUTH("S", 0, 1),
    SOUTH_EAST("SE", 1, 1),
    NOWHERE("0", 0, 0);

    public static final int NUM_DIRS;
    private static final int MASK;
    private static final double SQR;
    private static final Map<String, Direction8> name2direction;
    private static final List<Direction8> cardinals;
    private static boolean nowhereProhibited;
    private final int dx;
    private final int dy;
    private Crate crate;

    public static Direction8 get(String string) {
        Direction8 direction8 = name2direction.get(string.toUpperCase());
        if (direction8 == null) {
            throw new IllegalArgumentException("\nNezn\u00e1m\u00fd sm\u011br s dan\u00fdm n\u00e1zvem \u010di zkratkou: " + string);
        }
        return direction8;
    }

    public static Direction8 get(int n) {
        if (n < 0) {
            n = 0x7FFFFFF8 + n;
        }
        Direction8 direction8 = Direction8.values()[n &= 7];
        return direction8;
    }

    public static List<Direction8> cardinals() {
        return cardinals;
    }

    public static Direction8[] values4() {
        return new Direction8[]{EAST, NORTH, WEST, SOUTH};
    }

    public static boolean prohibitNowhere(boolean bl) {
        boolean bl2 = nowhereProhibited;
        nowhereProhibited = bl;
        return bl2;
    }

    private Direction8(String string2, int n2, int n3) {
        this.dx = n2;
        this.dy = n3;
        this.crate = new Crate();
        this.crate.shortcut = string2;
    }

    public boolean isCardinal() {
        return (this.ordinal() & 1) == 0 && this != NOWHERE;
    }

    public int ordinal4() {
        this.verifyCardinal();
        return this.ordinal() / 2;
    }

    public Position nextPosition(Position position) {
        this.verifyAllowed();
        return new Position(position.x + this.dx, position.y + this.dy);
    }

    public Position nextPosition(Position position, int n) {
        this.verifyAllowed();
        if (this.dx != 0 && this.dy != 0) {
            int n2 = (int)(SQR * (double)n + 0.5);
            return new Position(position.x + n2, position.y + n2);
        }
        return new Position(position.x + this.dx * n, position.y + this.dy * n);
    }

    public int nextX(int n) {
        this.verifyAllowed();
        return n + this.dx;
    }

    public double nextX(int n, int n2) {
        this.verifyAllowed();
        if (this.dx != 0 && this.dy != 0) {
            return (double)n + SQR * (double)this.dx * (double)n2;
        }
        return n + this.dx * n2;
    }

    public int nextY(int n) {
        this.verifyAllowed();
        return n + this.dy;
    }

    public double nextY(int n, int n2) {
        this.verifyAllowed();
        if (this.dx != 0 && this.dy != 0) {
            return (double)n + SQR * (double)this.dy * (double)n2;
        }
        return n + this.dy * n2;
    }

    public int dx() {
        this.verifyAllowed();
        return this.dx;
    }

    public int dy() {
        this.verifyAllowed();
        return this.dy;
    }

    public Direction8 leftTurn() {
        return this.turnBy(2);
    }

    public Direction8 rightTurn() {
        return this.turnBy(-2);
    }

    public Direction8 aboutTurn() {
        return this.turnBy(4);
    }

    public Direction8 halfLeft() {
        return this.turnBy(1);
    }

    public Direction8 halfRight() {
        return this.turnBy(-1);
    }

    public int ordinalDistanceTo(Direction8 direction8) {
        this.verifyAllowed();
        int n = this == NOWHERE || direction8 == NOWHERE ? 0 : direction8.ordinal() - this.ordinal();
        return n;
    }

    public Area turnInArea(Area area, Area area2) {
        return this.turnInArea(area, area2, EAST);
    }

    public Area turnInArea(Area area, Area area2, Direction8 direction8) {
        this.verifyAllowed();
        if (area.width != area.height) {
            throw new IllegalArgumentException("\nReferen\u010dn\u00ed oblast mus\u00ed b\u00fdt \u010dtvercov\u00e1: " + String.valueOf(area));
        }
        int n = direction8.ordinalDistanceTo(this);
        switch (n) {
            case 0: {
                int n2 = area.x + area2.x;
                int n3 = area.y + area2.y;
                int n4 = area2.width;
                int n5 = area2.height;
                return new Area(n2, n3, n4, n5);
            }
            case -6: 
            case 2: {
                int n6 = area.x + area2.y;
                int n7 = area.y - area2.x + area.width - area2.width;
                int n8 = area2.height;
                int n9 = area2.width;
                return new Area(n6, n7, n8, n9);
            }
            case -4: 
            case 4: {
                int n10 = area.x - area2.x + area.width - area2.width;
                int n11 = area.y - area2.y + area.height - area2.height;
                int n12 = area2.width;
                int n13 = area2.height;
                return new Area(n10, n11, n12, n13);
            }
            case -2: 
            case 6: {
                int n14 = area.x - area2.y + area.height - area2.height;
                int n15 = area.y + area2.x;
                int n16 = area2.height;
                int n17 = area2.width;
                return new Area(n14, n15, n16, n17);
            }
        }
        throw new RuntimeException("\nNen\u00ed mo\u017en\u00e9 oto\u010dit oblast ze sm\u011bru " + String.valueOf((Object)direction8) + " do sm\u011bru " + String.valueOf((Object)this));
    }

    public Area turnInAreaTo(Direction8 direction8, Area area, Area area2) {
        return direction8.turnInArea(area, area2, this);
    }

    public void turnTo4(ITurnable4 iTurnable4) {
        Direction8 direction8 = iTurnable4.getDirection();
        this.verifyCardinal();
        direction8.verifyCardinal();
        this.verifyAllowed();
        direction8.verifyAllowed();
        if (this == NOWHERE || direction8 == NOWHERE) {
            return;
        }
        int n = (direction8.ordinal() - this.ordinal()) / 2;
        switch (n) {
            case -1: 
            case 3: {
                iTurnable4.turnLeft();
                break;
            }
            case 0: {
                break;
            }
            case -3: 
            case 1: {
                iTurnable4.turnRight();
                break;
            }
            default: {
                iTurnable4.turnAbout();
            }
        }
    }

    public void turnTo8(ITurnable8 iTurnable8) {
        Direction8 direction8 = iTurnable8.getDirection();
        this.verifyAllowed();
        direction8.verifyAllowed();
        if (this == NOWHERE || direction8 == NOWHERE) {
            return;
        }
        int n = direction8.ordinal() - this.ordinal();
        switch (n) {
            case -3: 
            case 5: {
                iTurnable8.turnLeft();
                iTurnable8.halfLeft();
                return;
            }
            case -2: 
            case 6: {
                iTurnable8.turnLeft();
                return;
            }
            case -1: 
            case 7: {
                iTurnable8.halfLeft();
                return;
            }
            case 0: {
                return;
            }
            case -7: 
            case 1: {
                iTurnable8.halfRight();
                return;
            }
            case -6: 
            case 2: {
                iTurnable8.turnRight();
                return;
            }
            case -5: 
            case 3: {
                iTurnable8.turnRight();
                iTurnable8.halfRight();
                return;
            }
            case -4: 
            case 4: {
                iTurnable8.turnAbout();
                return;
            }
        }
        throw new RuntimeException("\nNen\u00ed mo\u017eno se oto\u010dit ze sm\u011bru " + String.valueOf((Object)direction8) + " do sm\u011bru " + String.valueOf((Object)this));
    }

    public Direction8 turnBy(int n) {
        this.verifyAllowed();
        return this == NOWHERE ? NOWHERE : Direction8.values()[MASK & n + this.ordinal()];
    }

    private void verifyAllowed() {
        if (nowhereProhibited && this == NOWHERE) {
            Throwable throwable = new Throwable();
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            StackTraceElement stackTraceElement = stackTraceElementArray[1];
            String string = stackTraceElement.getMethodName();
            throw new IllegalStateException("\nThis operation is prohibited for the direction NOWHERE: " + string);
        }
    }

    private void verifyCardinal() throws IllegalArgumentException {
        if (!this.isCardinal()) {
            String string = this.violatingMethod();
            throw new IllegalStateException("\nMetodu " + string + " nelze pou\u017e\u00edt pro sm\u011br " + String.valueOf((Object)this) + "\nLze ji pou\u017e\u00edt pouze pro \u010dty\u0159i hlavn\u00ed sv\u011btov\u00e9 strany");
        }
    }

    private String violatingMethod() {
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        StackTraceElement stackTraceElement = stackTraceElementArray[2];
        String string = stackTraceElement.getMethodName();
        return string;
    }

    static {
        NUM_DIRS = Direction8.values().length;
        MASK = NUM_DIRS - 2;
        SQR = Math.sqrt(0.5);
        name2direction = new HashMap<String, Direction8>(NUM_DIRS * 3);
        cardinals = List.of(EAST, NORTH, WEST, SOUTH);
        nowhereProhibited = false;
        if (NUM_DIRS != 9) {
            throw new RuntimeException("\nNabouran\u00fd zdrojov\u00fd k\u00f3d - \u0161patn\u00fd po\u010det sm\u011br\u016f");
        }
        for (Direction8 direction8 : Direction8.values()) {
            name2direction.put(direction8.name(), direction8);
            name2direction.put(direction8.crate.shortcut, direction8);
            direction8.crate = null;
        }
    }

    private static class Crate {
        String shortcut;

        private Crate() {
        }
    }
}

