/*
 * Decompiled with CFR 0.152.
 */
package ruplib.geom;

import ruplib.geom.Direction8;
import ruplib.geom.IChangeable;
import ruplib.geom.IModular;
import ruplib.geom.IResizable;
import ruplib.geom.Size;
import ruplib.util.IO;

public class Resizer {
    private static final int PERIOD = 30;
    private int power;

    public Resizer() {
        this(1);
    }

    public Resizer(int n) {
        this.power = n;
    }

    public void resizeByMultipleOf(double d, IModular iModular) {
        this.resizeByMultipleOf(d, iModular, Direction8.NORTH_WEST);
    }

    public void resizeByMultipleOf(double d, IModular iModular, Direction8 direction8) {
        int n = (int)((double)iModular.getModule() * d);
        this.resize(iModular, n, direction8);
    }

    public void resizeByMultipleOf(double d, IResizable iResizable) {
        int n = (int)Math.round((double)iResizable.getWidth() * d);
        int n2 = (int)Math.round((double)iResizable.getHeight() * d);
        this.resize(iResizable, n, n2, Direction8.NORTH_WEST);
    }

    public void resizeByMultipleOf(double d, IChangeable iChangeable, Direction8 direction8) {
        int n = (int)Math.round((double)iChangeable.getWidth() * d);
        int n2 = (int)Math.round((double)iChangeable.getHeight() * d);
        this.resize(iChangeable, n, n2, direction8);
    }

    public void resizeTo(int n, IModular iModular) {
        this.resize(iModular, n, Direction8.NORTH_WEST);
    }

    public void resizeTo(int n, IModular iModular, Direction8 direction8) {
        this.resize(iModular, n, direction8);
    }

    public void resizeTo(Size size, IResizable iResizable) {
        this.resize(iResizable, size.width, size.height, Direction8.NORTH_WEST);
    }

    public void resizeTo(int n, int n2, IResizable iResizable) {
        this.resize(iResizable, n, n2, Direction8.NORTH_WEST);
    }

    public void resizeTo(Size size, IChangeable iChangeable, Direction8 direction8) {
        this.resize(iChangeable, size.width, size.height, direction8);
    }

    public void resizeTo(int n, int n2, IChangeable iChangeable, Direction8 direction8) {
        this.resize(iChangeable, n, n2, direction8);
    }

    public void resizeBy(int n, IModular iModular) {
        this.resizeBy(n, iModular, Direction8.NORTH_WEST);
    }

    public void resizeBy(int n, IModular iModular, Direction8 direction8) {
        this.resize(iModular, iModular.getModule() + n, direction8);
    }

    public void resizeBy(Size size, IResizable iResizable) {
        this.resizeBy(size.width, size.height, iResizable);
    }

    public void resizeBy(int n, int n2, IResizable iResizable) {
        int n3 = iResizable.getWidth() + n;
        int n4 = iResizable.getHeight() + n2;
        this.resize(iResizable, n3, n4, Direction8.NORTH_WEST);
    }

    public void resizeBy(Size size, IChangeable iChangeable, Direction8 direction8) {
        this.resizeBy(size.width, size.height, iChangeable, direction8);
    }

    public void resizeBy(int n, int n2, IChangeable iChangeable, Direction8 direction8) {
        int n3 = iChangeable.getWidth() + n;
        int n4 = iChangeable.getHeight() + n2;
        this.resize(iChangeable, n3, n4, direction8);
    }

    private void resize(IModular iModular, int n, Direction8 direction8) {
        this.resize(new Modular2Changeable(this, iModular), n, n, direction8);
    }

    private void resize(IResizable iResizable, int n, int n2, Direction8 direction8) {
        int n3 = iResizable.getWidth();
        int n4 = iResizable.getHeight();
        int n5 = n - n3;
        int n6 = n2 - n4;
        int n7 = (int)(Math.hypot(n5, n6) / (double)this.power);
        double d = (double)n5 / (double)n7;
        double d2 = (double)n6 / (double)n7;
        this.execute(iResizable, n7, d, d2, direction8);
    }

    private void execute(IResizable iResizable, int n, double d, double d2, Direction8 direction8) {
        if (direction8 == null) {
            direction8 = Direction8.NOWHERE;
        }
        IChangeable iChangeable = null;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (direction8 != Direction8.NORTH_WEST) {
            if (!(iResizable instanceof IChangeable)) {
                throw new IllegalArgumentException("\nOnly the instances of IChangeable can be resized with the fixed point in the direction " + String.valueOf((Object)direction8));
            }
            iChangeable = (IChangeable)iResizable;
            d5 = (double)iChangeable.getX() + 0.4;
            d6 = (double)iChangeable.getY() + 0.4;
            if (direction8 == Direction8.SOUTH_EAST || direction8 == Direction8.EAST || direction8 == Direction8.NORTH_EAST) {
                d3 = -d;
            } else if (direction8 == Direction8.NORTH || direction8 == Direction8.SOUTH || direction8 == Direction8.NOWHERE) {
                d3 = -d / 2.0;
            }
            if (direction8 == Direction8.SOUTH_WEST || direction8 == Direction8.SOUTH || direction8 == Direction8.SOUTH_EAST) {
                d4 = -d2;
            } else if (direction8 == Direction8.EAST || direction8 == Direction8.WEST || direction8 == Direction8.NOWHERE) {
                d4 = -d2 / 2.0;
            }
        }
        int n2 = iResizable.getWidth();
        int n3 = iResizable.getHeight();
        double d7 = (double)n2 + 0.4;
        double d8 = (double)n3 + 0.4;
        while (n-- > 0) {
            IO.pause(30);
            iResizable.setSize((int)(d7 += d), (int)(d8 += d2));
            if (direction8 == Direction8.NORTH_WEST) continue;
            iChangeable.setPosition((int)(d5 += d3), (int)(d6 += d4));
        }
    }

    public class Modular2Changeable
    implements IChangeable {
        private final IModular delegate;

        public Modular2Changeable(Resizer resizer, IModular iModular) {
            this.delegate = iModular;
        }

        @Override
        public int getWidth() {
            return this.delegate.getModule();
        }

        @Override
        public int getHeight() {
            return this.delegate.getModule();
        }

        @Override
        public void setSize(int n, int n2) {
            if (n != n2) {
                throw new IllegalArgumentException("\nThe width and height of a modular object should be the same: width=" + n + ", height=" + n2);
            }
            this.delegate.setModule(n);
        }

        @Override
        public int getX() {
            return this.delegate.getX();
        }

        @Override
        public int getY() {
            return this.delegate.getY();
        }

        @Override
        public void setPosition(int n, int n2) {
            this.delegate.setPosition(n, n2);
        }
    }
}

