/*
 * Decompiled with CFR 0.152.
 */
package ruplib.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;

public class ContainerUtil {
    public static final char AP = '{';
    public static final char ZP = '}';
    public static final char A_ = "\u00ab".charAt(0);
    public static final char _Z = "\u00bb".charAt(0);
    private static final String SEP = ", ";
    private static final int SEP_LENGTH = ", ".length();

    public static <E> void addAll(Collection<E> collection, E ... EArray) {
        collection.addAll(Arrays.asList(EArray));
    }

    public static String arr2String(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder().append('{');
        for (int n : nArray) {
            stringBuilder.append(A_).append(n).append(_Z).append(SEP);
        }
        return ContainerUtil.closedStringBuilder(stringBuilder);
    }

    public static String arr2nlString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            stringBuilder.append(A_).append(object).append(_Z).append('\n');
        }
        return stringBuilder.toString();
    }

    public static String arr2String(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder().append('{');
        for (Object object : objectArray) {
            stringBuilder.append('{').append(object).append('}').append(SEP);
        }
        return ContainerUtil.closedStringBuilder(stringBuilder);
    }

    public static <E> ArrayList<E> newCollection(E ... EArray) {
        return ContainerUtil.newArrayList(EArray);
    }

    public static <E> List<E> newList(E ... EArray) {
        return ContainerUtil.newArrayList(EArray);
    }

    public static <E> ArrayList<E> newArrayList(E ... EArray) {
        ArrayList<E> arrayList = new ArrayList<E>(Arrays.asList(EArray));
        return arrayList;
    }

    public static <E> Set<E> newSet(E ... EArray) {
        return ContainerUtil.newHashSet(EArray);
    }

    public static <E> HashSet<E> newHashSet(E ... EArray) {
        HashSet<E> hashSet = new HashSet<E>(Arrays.asList(EArray));
        return hashSet;
    }

    public static <E> HashSet<E> newLinkedHashSet(E ... EArray) {
        LinkedHashSet<E> linkedHashSet = new LinkedHashSet<E>(Arrays.asList(EArray));
        return linkedHashSet;
    }

    public static <E extends Enum<E>> EnumSet<E> newEnumSet(E ... EArray) {
        if (EArray.length == 0) {
            throw new RuntimeException("\nTato metoda neum\u00ed vytvo\u0159it pr\u00e1zdnou mno\u017einu - pou\u017eijte java.util.EnumSet.noneOf(Class<E>)");
        }
        EnumSet<E[]> enumSet = EnumSet.of(EArray[0], EArray);
        return enumSet;
    }

    public static <K, V> Map.Entry<K, V> e(K k, V v) {
        return new AbstractMap.SimpleEntry<K, V>(k, v);
    }

    public static <K, V> Map<K, V> newMap(IntFunction<Map<K, V>> intFunction, Map.Entry<K, V> ... entryArray) {
        Map<K, V> map = intFunction.apply(entryArray.length);
        for (Map.Entry<K, V> entry : entryArray) {
            map.put(entry.getKey(), entry.getValue());
        }
        return map;
    }

    public static <K, V> HashMap<K, V> newHashMap(Map.Entry<K, V> ... entryArray) {
        IntFunction<Map<K, V>> intFunction = HashMap::new;
        Map<K, V> map = ContainerUtil.newMap(intFunction, entryArray);
        return (HashMap)map;
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map.Entry<K, V> ... entryArray) {
        IntFunction<Map<K, V>> intFunction = LinkedHashMap::new;
        Map<K, V> map = ContainerUtil.newMap(intFunction, entryArray);
        return (LinkedHashMap)map;
    }

    public static boolean strArrEqualsIgnoreCase(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static String closedStringBuilder(StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (n > 1) {
            stringBuilder.delete(stringBuilder.length() - SEP_LENGTH, stringBuilder.length());
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private ContainerUtil() {
    }
}

