/*
 * Decompiled with CFR 0.152.
 */
package ruplib.util;

public final class Number2CZWords {
    public static final long MAX = Long.MAX_VALUE;
    private static final String[] UNITS__STRINGSCZ = new String[]{"", "jedna", "dva", "t\u0159i", "\u010dty\u0159i", "p\u011bt", "\u0161est", "sedm", "osm", "dev\u011bt", "deset", "jeden\u00e1ct", "dvan\u00e1ct", "t\u0159in\u00e1ct", "\u010dtrn\u00e1ct", "patn\u00e1ct", "\u0161estn\u00e1ct", "sedmn\u00e1ct", "osmn\u00e1ct", "devaten\u00e1ct"};
    private static final String[] TENS_CZ = new String[]{"", "", "dvacet", "t\u0159icet", "\u010dty\u0159icet", "pades\u00e1t", "\u0161edes\u00e1t", "sedmdes\u00e1t", "osmdes\u00e1t", "devades\u00e1t"};
    private static final String[] HUNDREDS_CZ = new String[]{"", "sto", "dv\u011b st\u011b", "t\u0159i sta", "\u010dty\u0159i sta", "p\u011bt set", "\u0161est set", "sedm set", "osm set", "dev\u011bt set"};
    private static final String[][] ORDERS_CZ = new String[][]{null, {"tis\u00edc", "tis\u00edce", "tis\u00edc"}, {"milion", "miliony", "milion\u016f"}, {"miliarda", "miliardy", "miliard"}, {"bilion", "biliony", "bilion\u016f"}, {"biliarda", "biliardy", "biliard"}, {"trilion", "trliony", "trilion\u016f"}};

    public static String inCzech(long l) {
        Number2CZWords.verify(l);
        return Number2CZWords.convertCZ(l);
    }

    private static String convertCZ(long l) {
        if (l == 0L) {
            return "nula";
        }
        String[] stringArray = new String[ORDERS_CZ.length];
        int n = Number2CZWords.prepareTriplets(stringArray, l);
        String string = Number2CZWords.prepareResult(n, stringArray);
        return string;
    }

    private static int prepareTriplets(String[] stringArray, long l) {
        stringArray[0] = Number2CZWords.hundredsCZ((int)(l % 1000L));
        int n = 1;
        while ((l /= 1000L) > 0L) {
            String string;
            int n2 = (int)(l % 1000L);
            if (n2 == 0) {
                ++n;
                continue;
            }
            String string2 = Number2CZWords.hundredsCZ(n2);
            if (n2 == 1) {
                string = ORDERS_CZ[n][0];
            } else if (n2 <= 3) {
                string = ORDERS_CZ[n][1];
                if (n2 == 2 && n > 2 && (n & 1) == 1) {
                    string2 = "dv\u011b";
                }
            } else {
                string = ORDERS_CZ[n][2];
            }
            stringArray[n] = string2 + " " + string;
            ++n;
        }
        return n;
    }

    private static String hundredsCZ(int n) {
        if (n < 20) {
            return UNITS__STRINGSCZ[n];
        }
        int n2 = n % 10;
        int n3 = n / 10;
        int n4 = n3 / 10;
        return HUNDREDS_CZ[n4] + (n4 > 0 && n % 100 > 0 ? " " : "") + (String)((n3 %= 10) < 2 ? UNITS__STRINGSCZ[10 * n3 + n2] : TENS_CZ[n3] + (n2 > 0 ? " " : "") + UNITS__STRINGSCZ[n2]);
    }

    private static String prepareResult(int n, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n - 1; i >= 0; --i) {
            if (stringArray[i] == null) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(stringArray[i]);
        }
        String string = stringBuilder.toString();
        return string;
    }

    private static void verify(long l) throws IllegalArgumentException {
        if (l < 0L || Long.MAX_VALUE < l) {
            throw new IllegalArgumentException("Lze p\u0159ev\u00e1d\u011bt pouze nez\u00e1porn\u00e1 \u010d\u00edsla do 9223372036854775807");
        }
    }

    private Number2CZWords() {
    }
}

