/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvasmanager;

import ruplib.canvasmanager.ICMShape;
import ruplib.canvasmanager.Painter;
import ruplib.geom.AShape;
import ruplib.geom.Area;
import ruplib.geom.Position;
import ruplib.geom.Size;
import ruplib.util.IColorable;
import ruplib.util.NamedColor;

public class Ellipse
extends AShape
implements ICMShape,
IColorable {
    public static final NamedColor DEFAULT_COLOR = NamedColor.BLUE;
    private NamedColor color;

    public Ellipse() {
        this(0, 0, 2 * CM.getStep(), CM.getStep());
    }

    public Ellipse(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, DEFAULT_COLOR);
    }

    public Ellipse(int n, int n2, int n3, int n4, NamedColor namedColor) {
        super(n, n2, n3, n4);
        this.color = namedColor;
    }

    public Ellipse(Position position, Size size, NamedColor namedColor) {
        this(position.x, position.y, size.width, size.height, namedColor);
    }

    public Ellipse(Area area, NamedColor namedColor) {
        this(area.x, area.y, area.width, area.height, namedColor);
    }

    @Override
    public final NamedColor getColor() {
        return this.color;
    }

    @Override
    public final void setColor(NamedColor namedColor) {
        this.color = namedColor;
        CM.repaint();
    }

    @Override
    public void setPosition(int n, int n2) {
        CM.changeTogether(() -> super.setPosition(n, n2));
    }

    @Override
    public void setSize(int n, int n2) {
        CM.changeTogether(() -> super.setSize(n, n2));
    }

    @Override
    public Ellipse copy() {
        return new Ellipse(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.color);
    }

    @Override
    public void paint(Painter painter) {
        painter.fillEllipse(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.color);
    }

    @Override
    protected String forToString() {
        return super.forToString() + ", color=" + String.valueOf(this.color);
    }
}

