/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvasmanager;

import ruplib.canvasmanager.IAdaptable;
import ruplib.canvasmanager.ICMPaintable;
import ruplib.canvasmanager.Painter;
import ruplib.geom.AMovable;
import ruplib.geom.Position;
import ruplib.util.IColorable;
import ruplib.util.ICopyable;
import ruplib.util.NamedColor;

public class Line
extends AMovable
implements ICopyable,
IAdaptable,
IColorable,
ICMPaintable {
    public static final NamedColor DEFAULT_COLOR = NamedColor.BLACK;
    private static int count = 0;
    private final int ID = ++count;
    protected int xEnd;
    protected int yEnd;
    private NamedColor color;

    public Line() {
        this(0, 0, CM.getWidth() / 2, CM.getHeight() / 2);
    }

    public Line(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, DEFAULT_COLOR);
    }

    public Line(Position position, Position position2) {
        this(position.x, position.y, position2.x, position2.y, DEFAULT_COLOR);
    }

    public Line(Position position, Position position2, NamedColor namedColor) {
        this(position.x, position.y, position2.x, position2.y, namedColor);
    }

    public Line(int n, int n2, int n3, int n4, NamedColor namedColor) {
        super(n, n2);
        this.xEnd = n3;
        this.yEnd = n4;
        this.color = namedColor;
    }

    @Override
    public NamedColor getColor() {
        return this.color;
    }

    @Override
    public void setColor(NamedColor namedColor) {
        this.color = namedColor;
        CM.repaint();
    }

    @Override
    public void setPosition(int n, int n2) {
        CM.changeTogether(() -> {
            this.xEnd = n + (this.xEnd - this.getX());
            this.yEnd = n2 + (this.yEnd - this.getY());
            super.setPosition(n, n2);
        });
    }

    public int getEndX() {
        return this.xEnd;
    }

    public int getEndY() {
        return this.yEnd;
    }

    public Position getEndPosition() {
        return new Position(this.getEndX(), this.getEndY());
    }

    public void setEndPosition(Position position) {
        this.setEndPosition(position.x, position.y);
    }

    public void setEndPosition(int n, int n2) {
        this.xEnd = n;
        this.yEnd = n2;
        CM.repaint();
    }

    public void connect(int n, int n2, int n3, int n4) {
        CM.changeTogether(() -> {
            this.setPosition(n, n2);
            this.xEnd = n3;
            this.yEnd = n4;
        });
    }

    @Override
    public Line copy() {
        return new Line(this.getX(), this.getY(), this.xEnd, this.yEnd, this.color);
    }

    @Override
    public String forToString() {
        return super.forToString() + ",xEnd=" + this.xEnd + ", yEnd=" + this.yEnd + ", color=" + String.valueOf(this.color);
    }

    @Override
    public void paint(Painter painter) {
        painter.drawLine(this.getX(), this.getY(), this.xEnd, this.yEnd, this.getColor());
    }

    @Override
    public void stepChanged(int n, int n2) {
        CM.changeTogether(() -> {
            double d = (double)n2 / (double)n;
            int n3 = (int)((double)this.getX() * d);
            int n4 = (int)((double)this.getY() * d);
            super.setPosition(n3, n4);
            this.xEnd = (int)((double)this.xEnd * d);
            this.yEnd = (int)((double)this.yEnd * d);
        });
    }
}

