/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvasmanager;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import ruplib.util.NamedColor;

public class Painter {
    public static final ImageObserver IMG_OBSERVER = new ImageObserver();
    private final Graphics2D g;

    Painter(Graphics2D graphics2D) {
        this.g = graphics2D;
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public void setFont(Font font) {
        this.g.setFont(font);
    }

    public NamedColor getBackground() {
        Color color = this.g.getBackground();
        NamedColor namedColor = NamedColor.getNamedColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
        return namedColor;
    }

    public void setBackground(NamedColor namedColor) {
        this.g.setBackground(namedColor.getAWTColor());
    }

    public Graphics2D getGraphics() {
        return this.g;
    }

    public void drawEllipse(int n, int n2, int n3, int n4, NamedColor namedColor) {
        this.g.setColor(namedColor.getAWTColor());
        this.g.drawOval(n, n2, n3, n4);
    }

    public void fillEllipse(int n, int n2, int n3, int n4, NamedColor namedColor) {
        this.g.setColor(namedColor.getAWTColor());
        this.g.fillOval(n, n2, n3, n4);
    }

    public void drawRectangle(int n, int n2, int n3, int n4, NamedColor namedColor) {
        this.g.setColor(namedColor.getAWTColor());
        this.g.drawRect(n, n2, n3, n4);
    }

    public void fillRectangle(int n, int n2, int n3, int n4, NamedColor namedColor) {
        this.g.setColor(namedColor.getAWTColor());
        this.g.fillRect(n, n2, n3, n4);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, NamedColor namedColor) {
        this.g.setColor(namedColor.getAWTColor());
        this.g.drawPolygon(nArray, nArray2, Math.min(nArray.length, nArray2.length));
    }

    public void fillPolygon(int[] nArray, int[] nArray2, NamedColor namedColor) {
        this.g.setColor(namedColor.getAWTColor());
        this.g.fillPolygon(nArray, nArray2, Math.min(nArray.length, nArray2.length));
    }

    public void drawLine(int n, int n2, int n3, int n4, NamedColor namedColor) {
        this.g.setColor(namedColor.getAWTColor());
        this.g.drawLine(n, n2, n3, n4);
    }

    public void drawText(String string, int n, int n2, NamedColor namedColor) {
        this.g.setColor(namedColor.getAWTColor());
        this.g.drawString(string, n, n2);
    }

    public void drawPicture(int n, int n2, Image image, AffineTransform affineTransform) {
        if (affineTransform == null) {
            this.g.drawImage(image, n, n2, IMG_OBSERVER);
        } else {
            this.g.drawImage(image, affineTransform, IMG_OBSERVER);
        }
    }

    public static class ImageObserver
    implements java.awt.image.ImageObserver {
        @Override
        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            return false;
        }
    }
}

