/*
 * Decompiled with CFR 0.152.
 */
package ruplib.canvasmanager;

import ruplib.canvasmanager.ICMShape;
import ruplib.canvasmanager.Painter;
import ruplib.geom.AShape;
import ruplib.geom.Area;
import ruplib.geom.Direction8;
import ruplib.geom.IDirectable;
import ruplib.geom.Position;
import ruplib.geom.Size;
import ruplib.util.IColorable;
import ruplib.util.NamedColor;

public class Triangle
extends AShape
implements ICMShape,
IColorable,
IDirectable {
    public static final NamedColor DEFAULT_COLOR = NamedColor.GREEN;
    public static final Direction8 DEFAULT_DIRECTION = Direction8.NORTH;
    private NamedColor color;
    private Direction8 dir8;

    public Triangle() {
        this(0, 0, 2 * CM.getStep(), CM.getStep());
    }

    public Triangle(int n, int n2, int n3, int n4) {
        this(n, n2, n3, n4, DEFAULT_COLOR, DEFAULT_DIRECTION);
    }

    public Triangle(int n, int n2, int n3, int n4, NamedColor namedColor) {
        this(n, n2, n3, n4, namedColor, DEFAULT_DIRECTION);
    }

    public Triangle(int n, int n2, int n3, int n4, Direction8 direction8) {
        this(n, n2, n3, n4, DEFAULT_COLOR, direction8);
    }

    public Triangle(int n, int n2, int n3, int n4, NamedColor namedColor, Direction8 direction8) {
        super(n, n2, n3, n4);
        if (direction8 == Direction8.NOWHERE) {
            throw new IllegalArgumentException("\nnew Triangle: Troj\u00faheln\u00edk mus\u00ed m\u00edt zadan\u00fd existuj\u00edc\u00ed sm\u011br");
        }
        this.color = namedColor;
        this.dir8 = direction8;
    }

    public Triangle(Position position, Size size, NamedColor namedColor, Direction8 direction8) {
        this(position.x, position.y, size.width, size.height, namedColor, direction8);
    }

    public Triangle(Area area, NamedColor namedColor, Direction8 direction8) {
        this(area.x, area.y, area.width, area.height, namedColor, direction8);
    }

    @Override
    public final NamedColor getColor() {
        return this.color;
    }

    @Override
    public final void setColor(NamedColor namedColor) {
        this.color = namedColor;
        CM.repaint();
    }

    @Override
    public Direction8 getDirection() {
        return this.dir8;
    }

    @Override
    public void setDirection(Direction8 direction8) {
        assert (direction8 != Direction8.NOWHERE) : "Troj\u00faheln\u00edk mus\u00ed b\u00fdt nato\u010den do n\u011bkter\u00e9ho z \u0159\u00e1dn\u00fdch sm\u011br\u016f";
        this.dir8 = direction8;
        CM.repaint();
    }

    @Override
    public void setPosition(int n, int n2) {
        CM.changeTogether(() -> super.setPosition(n, n2));
    }

    @Override
    public void setSize(int n, int n2) {
        CM.changeTogether(() -> super.setSize(n, n2));
    }

    @Override
    public Triangle copy() {
        return new Triangle(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.color, this.dir8);
    }

    @Override
    public void paint(Painter painter) {
        int[][] nArray = this.getVertexes();
        painter.fillPolygon(nArray[0], nArray[1], this.color);
    }

    @Override
    protected String forToString() {
        return super.forToString() + ", color=" + String.valueOf(this.color) + ", direction=" + String.valueOf((Object)this.dir8);
    }

    private int[][] getVertexes() {
        int[] nArray = null;
        int[] nArray2 = null;
        switch (this.dir8) {
            case EAST: {
                nArray = new int[]{this.getX(), this.getX() + this.getWidth(), this.getX()};
                nArray2 = new int[]{this.getY(), this.getY() + this.getHeight() / 2, this.getY() + this.getHeight()};
                break;
            }
            case NORTH_EAST: {
                nArray = new int[]{this.getX(), this.getX() + this.getWidth(), this.getX() + this.getWidth()};
                nArray2 = new int[]{this.getY(), this.getY(), this.getY() + this.getHeight()};
                break;
            }
            case NORTH: {
                nArray = new int[]{this.getX(), this.getX() + this.getWidth() / 2, this.getX() + this.getWidth()};
                nArray2 = new int[]{this.getY() + this.getHeight(), this.getY(), this.getY() + this.getHeight()};
                break;
            }
            case NORTH_WEST: {
                nArray = new int[]{this.getX(), this.getX(), this.getX() + this.getWidth()};
                nArray2 = new int[]{this.getY() + this.getHeight(), this.getY(), this.getY()};
                break;
            }
            case WEST: {
                nArray = new int[]{this.getX(), this.getX() + this.getWidth(), this.getX() + this.getWidth()};
                nArray2 = new int[]{this.getY() + this.getHeight() / 2, this.getY(), this.getY() + this.getHeight()};
                break;
            }
            case SOUTH_WEST: {
                nArray = new int[]{this.getX(), this.getX(), this.getX() + this.getWidth()};
                nArray2 = new int[]{this.getY(), this.getY() + this.getHeight(), this.getY() + this.getHeight()};
                break;
            }
            case SOUTH: {
                nArray = new int[]{this.getX(), this.getX() + this.getWidth() / 2, this.getX() + this.getWidth()};
                nArray2 = new int[]{this.getY(), this.getY() + this.getHeight(), this.getY()};
                break;
            }
            case SOUTH_EAST: {
                nArray = new int[]{this.getX(), this.getX() + this.getWidth(), this.getX() + this.getWidth()};
                nArray2 = new int[]{this.getY() + this.getHeight(), this.getY() + this.getHeight(), this.getY()};
                break;
            }
            default: {
                throw new IllegalStateException("Instance ukazuje do nedefinovan\u00e9ho sm\u011bru");
            }
        }
        return new int[][]{nArray, nArray2};
    }
}

