/*
 * Decompiled with CFR 0.152.
 */
package ruplib.geom;

import ruplib.geom.IMovable;
import ruplib.geom.Position;
import ruplib.util.IO;

public class Mover {
    private static final int PERIOD = 50;
    private static int countCreated = 0;
    private final int ID = ++countCreated;
    private final String name;
    private int speed;

    public Mover() {
        this(1);
    }

    public Mover(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("The given speed must be positive!");
        }
        this.speed = n;
        this.name = this.getClass().getSimpleName() + "[ID=" + this.ID + ", speed=" + n + "]";
    }

    public void moveBy(int n, int n2, IMovable iMovable) {
        double d = Math.sqrt(n * n + n2 * n2);
        int n3 = (int)(d / (double)this.speed);
        double d2 = ((double)n + 0.4) / (double)n3;
        double d3 = ((double)n2 + 0.4) / (double)n3;
        int n4 = iMovable.getX();
        int n5 = iMovable.getY();
        double d4 = (double)n4 + 0.4;
        double d5 = (double)n5 + 0.4;
        for (int i = n3; i > 0; --i) {
            iMovable.setPosition((int)(d4 += d2), (int)(d5 += d3));
            IO.pause(50);
        }
    }

    public void moveBy(Position position, IMovable iMovable) {
        this.moveBy(position.x, position.y, iMovable);
    }

    public void moveTo(int n, int n2, IMovable iMovable) {
        int n3 = iMovable.getX();
        int n4 = iMovable.getY();
        this.moveBy(n - n3, n2 - n4, iMovable);
    }

    public void moveTo(Position position, IMovable iMovable) {
        this.moveTo(position.x, position.y, iMovable);
    }

    public String toString() {
        return this.name;
    }
}

