/*
 * Decompiled with CFR 0.152.
 */
package ruplib.util;

import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class IO {
    private static final Insets ZERO_BORDER = new Insets(0, 0, 0, 0);
    private static final Insets INSETS_DIF;
    private static Point windowLocation;
    private static boolean testMode;
    private static Throwable callStack;

    public static void pause(int n) {
        if (testMode) {
            Informant.informer.hold(n);
        } else {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static String toASCII(String string) {
        return ToASCII.text(string);
    }

    public static void setDialogsPosition(int n, int n2) {
        windowLocation = new Point(n, n2);
    }

    public static boolean confirm(Object object) {
        return IO.choose(object, "ANO", "NE") == 0;
    }

    public static int choose(Object object, String ... stringArray) {
        JOptionPane jOptionPane = new JOptionPane(object, 3, 0, null, stringArray, null);
        IO.processJOP(jOptionPane);
        String string = (String)jOptionPane.getValue();
        if (string == null) {
            IO.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    public static double enter(Object object, double d) {
        String string = Double.toString(d).trim();
        String string2 = IO.enter(object, string);
        return Double.parseDouble(string2);
    }

    public static int enter(Object object, int n) {
        String string = Integer.toString(n).trim();
        String string2 = IO.enter(object, string);
        return Integer.parseInt(string2);
    }

    public static String enter(Object object, String string) {
        JOptionPane jOptionPane = new JOptionPane(object, 3, -1);
        jOptionPane.setWantsInput(true);
        jOptionPane.setInitialSelectionValue(string);
        IO.processJOP(jOptionPane);
        String string2 = jOptionPane.getInputValue().toString();
        return string2;
    }

    public static String select(Object object, String ... stringArray) {
        JOptionPane jOptionPane = new JOptionPane(object, 3, 2, null, null, null);
        jOptionPane.setWantsInput(true);
        jOptionPane.setSelectionValues(stringArray);
        jOptionPane.setInitialSelectionValue(null);
        IO.processJOP(jOptionPane);
        String string = jOptionPane.getInputValue().toString();
        return string;
    }

    public static void inform(Object object) {
        if (testMode) {
            Informant.informer.test(object);
        } else {
            JOptionPane jOptionPane = new JOptionPane(object, 1);
            IO.processJOP(jOptionPane);
        }
    }

    private static void exit(int n) {
        callStack.printStackTrace(System.out);
        System.exit(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processJOP(JOptionPane jOptionPane) {
        callStack = new Throwable("Program byl p\u0159ed\u010dasn\u011b ukon\u010den u\u017eivatelem z dialogov\u00e9ho okna");
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        JDialog jDialog = jOptionPane.createDialog(null, "Information");
        jDialog.addWindowListener(new WinAdapter(jDialog, atomicBoolean));
        jDialog.setModal(false);
        jDialog.setVisible(true);
        jDialog.setLocation(windowLocation);
        jDialog.toFront();
        jDialog.setAlwaysOnTop(true);
        AtomicBoolean atomicBoolean2 = atomicBoolean;
        synchronized (atomicBoolean2) {
            while (!atomicBoolean.get()) {
                try {
                    atomicBoolean.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private IO() {
    }

    static {
        windowLocation = new Point(0, 0);
        testMode = false;
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            JFrame jFrame = new JFrame();
            jFrame.setLocation(-1000, -1000);
            jFrame.setResizable(true);
            jFrame.pack();
            Insets insets = jFrame.getInsets();
            jFrame.setResizable(false);
            Insets insets2 = jFrame.getInsets();
            Insets insets3 = new Insets(insets.top - insets2.top, insets.left - insets2.left, insets.bottom - insets2.bottom, insets.right - insets2.right);
            if (ZERO_BORDER.equals(insets3)) {
                int n = insets.left == 8 ? 5 : 1;
                insets3 = new Insets(n, n, n, n);
            }
            INSETS_DIF = insets3;
        } else {
            INSETS_DIF = ZERO_BORDER;
        }
    }

    public static class Informant {
        public static final Informant informer = new Informant();
        private final List<ITester> list = new ArrayList<ITester>();

        private Informant() {
        }

        public void register(ITester iTester) {
            if (this.list.contains(iTester)) {
                return;
            }
            this.list.add(iTester);
            testMode = true;
        }

        public void unregister(ITester iTester) {
            this.list.remove(iTester);
            if (this.list.isEmpty()) {
                testMode = false;
            }
        }

        private void hold(int n) {
            for (ITester iTester : this.list) {
                iTester.pause(n);
            }
        }

        private void test(Object object) {
            for (ITester iTester : this.list) {
                iTester.inform(object);
            }
        }
    }

    private static class ToASCII {
        private static final Map<Character, String> CONVERSION;

        public static String text(CharSequence charSequence) {
            int n = charSequence.length();
            StringBuilder stringBuilder = new StringBuilder(n);
            for (int i = 0; i < n; ++i) {
                char c = charSequence.charAt(i);
                if (c < '\u0080') {
                    stringBuilder.append(c);
                    continue;
                }
                if (CONVERSION.containsKey(Character.valueOf(c))) {
                    stringBuilder.append(CONVERSION.get(Character.valueOf(c)));
                    continue;
                }
                stringBuilder.append(ToASCII.expand(c));
            }
            return stringBuilder.toString();
        }

        private static String expand(char c) {
            return String.format("\\u%04x", c);
        }

        private ToASCII() {
        }

        static {
            String[][] stringArrayArray;
            CONVERSION = new HashMap<Character, String>(64);
            for (String[] stringArray : stringArrayArray = new String[][]{{"\u00c1", "A"}, {"\u00e1", "a"}, {"\u00c4", "AE"}, {"\u00e4", "ae"}, {"\u010c", "C"}, {"\u010d", "c"}, {"\u010e", "D"}, {"\u010f", "d"}, {"\u00cb", "E"}, {"\u00eb", "e"}, {"\u00c9", "E"}, {"\u00e9", "e"}, {"\u011a", "E"}, {"\u011b", "e"}, {"\u00cd", "I"}, {"\u00ed", "i"}, {"\u00cf", "IE"}, {"\u00ef", "ie"}, {"\u0139", "L"}, {"\u013a", "l"}, {"\u013d", "L"}, {"\u013e", "l"}, {"\u0147", "N"}, {"\u0148", "n"}, {"\u00d3", "O"}, {"\u00f3", "o"}, {"\u00d6", "OE"}, {"\u00f6", "oe"}, {"\u00d4", "O"}, {"\u00f4", "o"}, {"\u0154", "R"}, {"\u0155", "r"}, {"\u0158", "R"}, {"\u0159", "r"}, {"\u0160", "S"}, {"\u0161", "s"}, {"\u0164", "T"}, {"\u0165", "t"}, {"\u00da", "U"}, {"\u00fa", "u"}, {"\u00dc", "UE"}, {"\u00fc", "ue"}, {"\u016e", "U"}, {"\u016f", "u"}, {"\u00dd", "Y"}, {"\u00fd", "y"}, {"\u0178", "YE"}, {"\u00ff", "ye"}, {"\u017d", "Z"}, {"\u017e", "z"}, {"\u00df", "ss"}, {"\u2039", "<"}, {"\u203a", ">"}, {"\u00ab", "<<"}, {"\u00bb", ">>"}, {"\u00a9", "(c)"}, {"\u00ae", "(R)"}, {"\u201e", "\""}, {"\u201c", "\""}, {"\u201d", "\""}, {"\u201a", "'"}, {"\u2018", "'"}, {"\u2019", "'"}, {"\u00d7", "x"}, {"\u00f7", ":"}, {"\u2013", "-"}, {"\u2014", "-"}, {"\u00a6", "|"}}) {
                CONVERSION.put(Character.valueOf(stringArray[0].charAt(0)), stringArray[1]);
            }
        }
    }

    public static class WinAdapter
    extends WindowAdapter {
        private final JDialog dialog;
        private final AtomicBoolean answered;

        public WinAdapter(JDialog jDialog, AtomicBoolean atomicBoolean) {
            this.dialog = jDialog;
            this.answered = atomicBoolean;
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            System.exit(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            windowLocation = this.dialog.getLocation();
            if (!this.dialog.isShowing()) {
                this.dialog.dispose();
                AtomicBoolean atomicBoolean = this.answered;
                synchronized (atomicBoolean) {
                    this.answered.set(true);
                    this.answered.notifyAll();
                }
            }
        }
    }

    public static interface ITester {
        public void pause(int var1);

        public void inform(Object var1);
    }

    public static class Correction {
        public static void windowLocation(Container container) {
        }

        public static void windowSize(Container container) {
        }

        private Correction() {
        }
    }
}

