/*
 * Decompiled with CFR 0.152.
 */
package ruplib.util;

import java.awt.Color;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ruplib.util.IO;

public class NamedColor {
    private static int count = 0;
    private static final int TRANSLUCENCE = 128;
    private static final int MINC = 32;
    private static final int MAXC = 255;
    private static final double CHANGE_KOEF = 0.7;
    private static final Map<String, NamedColor> name2namedColor = new LinkedHashMap<String, NamedColor>();
    private static final Map<String, NamedColor> nameRA2namedColor = new LinkedHashMap<String, NamedColor>();
    private static final Map<Color, NamedColor> color2namedColor = new LinkedHashMap<Color, NamedColor>();
    private static final List<NamedColor> namedColorList = new ArrayList<NamedColor>(32);
    public static final NamedColor BLACK = new NamedColor(Color.BLACK, "black");
    public static final NamedColor BLUE = new NamedColor(Color.BLUE, "blue");
    public static final NamedColor RED = new NamedColor(Color.RED, "red");
    public static final NamedColor MAGENTA = new NamedColor(Color.MAGENTA, "magenta");
    public static final NamedColor GREEN = new NamedColor(Color.GREEN, "green");
    public static final NamedColor CYAN = new NamedColor(Color.CYAN, "cyan");
    public static final NamedColor YELLOW = new NamedColor(Color.YELLOW, "yellow");
    public static final NamedColor WHITE = new NamedColor(Color.WHITE, "white");
    public static final NamedColor LIGHT_GRAY = new NamedColor(Color.LIGHT_GRAY, "lightgray");
    public static final NamedColor GRAY = new NamedColor(Color.GRAY, "gray");
    public static final NamedColor DARK_GRAY = new NamedColor(Color.DARK_GRAY, "darkgray");
    public static final NamedColor PINK = new NamedColor(Color.PINK, "pink");
    public static final NamedColor ORANGE = new NamedColor(Color.ORANGE, "orange");
    public static final NamedColor AMBER = new NamedColor(new Color(255, 204, 0, 255), "amber");
    public static final NamedColor BRICK = new NamedColor(new Color(255, 102, 0, 255), "brick");
    public static final NamedColor BROWN = new NamedColor(new Color(153, 51, 0, 255), "brown");
    public static final NamedColor CREAMY = new NamedColor(new Color(255, 255, 204, 255), "creamy");
    public static final NamedColor GOLD = new NamedColor(new Color(255, 224, 0, 255), "gold");
    public static final NamedColor KHAKI = new NamedColor(new Color(153, 153, 0, 255), "khaki");
    public static final NamedColor OCHRE = new NamedColor(new Color(255, 153, 0, 255), "ochre");
    public static final NamedColor SILVER = new NamedColor(new Color(216, 216, 216, 255), "silver");
    public static final NamedColor STEELY = new NamedColor(new Color(0, 153, 204, 255), "steely");
    public static final NamedColor MILKY = new NamedColor(new Color(255, 255, 255, 128), "milky");
    public static final NamedColor SMOKY = new NamedColor(new Color(128, 128, 128, 128), "smoky");
    public static final NamedColor NO = new NamedColor(new Color(0, 0, 0, 0), "no");
    private static boolean inUpperCase = false;
    private final String name;
    private final Color awtColor;
    private final int index = count++;

    public static NamedColor getNamedColor(int n) {
        return namedColorList.get(n);
    }

    public static NamedColor getNamedColor(String string) {
        NamedColor namedColor = name2namedColor.get(string.toLowerCase());
        if (namedColor != null) {
            return namedColor;
        }
        throw new IllegalArgumentException("\nNezn\u00e1m barvu nazvanou: " + string);
    }

    public static NamedColor getNamedColor(int n, int n2, int n3) {
        return NamedColor.getNamedColor(n, n2, n3, 1);
    }

    public static NamedColor getNamedColor(int n, int n2, int n3, int n4) {
        Color color = new Color(n, n2, n3, n4);
        NamedColor namedColor = color2namedColor.get(color);
        if (namedColor != null) {
            return namedColor;
        }
        String string = "Color(r=" + n + ",g=" + n2 + ",b=" + n3 + ",o=" + n4 + ")";
        return NamedColor.getNamedColor(n, n2, n3, n4, string);
    }

    public static NamedColor getNamedColor(int n, int n2, int n3, String string) {
        return NamedColor.getNamedColor(n, n2, n3, 255, string);
    }

    public static NamedColor getNamedColor(int n, int n2, int n3, int n4, String string) {
        if ((string = string.trim().toLowerCase()) == null || string.isEmpty()) {
            throw new IllegalArgumentException("\nThe color must have nonempty name");
        }
        Color color = new Color(n, n2, n3, n4);
        NamedColor namedColor = NamedColor.namedColor(string);
        NamedColor namedColor2 = color2namedColor.get(color);
        if (namedColor != null && namedColor == namedColor2) {
            return namedColor;
        }
        if (namedColor == null && namedColor2 == null) {
            return new NamedColor(n, n2, n3, n4, string);
        }
        NamedColor namedColor3 = namedColor2 != null ? namedColor2 : namedColor;
        Color color2 = namedColor3.awtColor;
        throw new IllegalArgumentException("\nThe given arguments collide with an existing color[existing \u00d7 given]:\nName :        " + namedColor3.getName() + " \u00d7 " + string + "\nRed:          " + color2.getRed() + " \u00d7 " + n + "\nGreen:        " + color2.getGreen() + " \u00d7 " + n2 + "\nBlue:         " + color2.getBlue() + " \u00d7 " + n3 + "\nTransparency: " + color2.getAlpha() + " \u00d7 " + n4);
    }

    public static NamedColor[] getArrayOfNamedColors() {
        return namedColorList.toArray(new NamedColor[namedColorList.size()]);
    }

    public static String[] getArrayOfNames() {
        String[] stringArray = name2namedColor.keySet().toArray(new String[name2namedColor.size()]);
        if (inUpperCase) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].toUpperCase();
            }
        }
        Arrays.sort(stringArray, Collator.getInstance());
        return stringArray;
    }

    public static List<NamedColor> getListOfNamedColors() {
        return Collections.unmodifiableList(namedColorList);
    }

    public static List<String> getListOfNames() {
        return Arrays.asList(NamedColor.getArrayOfNames());
    }

    public static boolean setInUppercase(boolean bl) {
        boolean bl2 = inUpperCase;
        inUpperCase = bl;
        return bl2;
    }

    public static void showDefinedNames() {
        String[] stringArray = NamedColor.getArrayOfNames();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n2 = string.length();
            if (n + n2 >= 64) {
                stringBuilder.append('\n');
                n = 0;
            }
            stringBuilder.append(string);
            n += n2 + 2;
            if (i >= stringArray.length) continue;
            stringBuilder.append(", ");
        }
        IO.inform(stringBuilder);
    }

    private static int d2i(double d) {
        int n = (int)(d * 255.0);
        return n;
    }

    private static NamedColor getNamedColor(Color color) {
        NamedColor namedColor = color2namedColor.get(color);
        if (namedColor != null) {
            return namedColor;
        }
        return NamedColor.getNamedColor(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    private static NamedColor namedColor(String string) {
        NamedColor namedColor = name2namedColor.get(string = string.toLowerCase());
        if (namedColor == null) {
            namedColor = nameRA2namedColor.get(string);
        }
        return namedColor;
    }

    private NamedColor(int n, int n2, int n3, int n4, String string) {
        this(new Color(n, n2, n3, n4), string);
    }

    private NamedColor(Color color, String string) {
        string = string.toLowerCase();
        this.awtColor = color;
        this.name = string;
        if (name2namedColor.containsKey(string) || color2namedColor.containsKey(color)) {
            throw new IllegalArgumentException("\nInternal error - the color " + this.getNamePrivate() + " and/or " + this.getCharacteristicsHexPrivate() + " already exists");
        }
        NamedColor namedColor = this;
        name2namedColor.put(string, namedColor);
        color2namedColor.put(this.awtColor, namedColor);
        namedColorList.add(namedColor);
        this.addNameWithoutAccents();
    }

    public Color getAWTColor() {
        return this.awtColor;
    }

    public String getCharacteristicsDec() {
        return String.format("%s(Dec:R=%d,G=%d,B=%d,A=%d)", this.name, this.awtColor.getRed(), this.awtColor.getGreen(), this.awtColor.getBlue(), this.awtColor.getAlpha());
    }

    public String getCharacteristicsHex() {
        return this.getCharacteristicsHexPrivate();
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.getNamePrivate();
    }

    public NamedColor brighter() {
        Color color = this.awtColor.brighter();
        if (color.equals(this.awtColor)) {
            color = new Color(Math.max(color.getRed(), 32), Math.max(color.getGreen(), 32), Math.max(color.getBlue(), 32), color.getAlpha());
        }
        return NamedColor.getNamedColor(color);
    }

    public NamedColor darker() {
        return NamedColor.getNamedColor(this.awtColor.darker());
    }

    public NamedColor inverse() {
        return NamedColor.getNamedColor(255 - this.awtColor.getRed(), 255 - this.awtColor.getGreen(), 255 - this.awtColor.getBlue(), this.awtColor.getAlpha());
    }

    public NamedColor lessTransparent() {
        int n = (int)((double)this.awtColor.getAlpha() * 0.7);
        return NamedColor.getNamedColor(new Color(this.awtColor.getRed(), this.awtColor.getGreen(), this.awtColor.getBlue(), n));
    }

    public NamedColor moreTransparent() {
        int n = (int)((double)this.awtColor.getAlpha() / 0.7);
        return NamedColor.getNamedColor(new Color(this.awtColor.getRed(), this.awtColor.getGreen(), this.awtColor.getBlue(), n));
    }

    public String toString() {
        return this.getName();
    }

    public NamedColor translucent() {
        String string;
        Color color = new Color(this.awtColor.getRed(), this.awtColor.getGreen(), this.awtColor.getBlue(), 128);
        NamedColor namedColor = color2namedColor.get(color);
        if (namedColor == null && (namedColor = name2namedColor.get(string = "translucent_" + this.name)) == null) {
            namedColor = NamedColor.getNamedColor(this.awtColor.getRed(), this.awtColor.getGreen(), this.awtColor.getBlue(), 128, string);
        }
        return namedColor;
    }

    private void addNameWithoutAccents() {
        String string = IO.toASCII(this.name);
        if (!this.name.equals(string)) {
            nameRA2namedColor.put(string, this);
        }
    }

    private String getCharacteristicsHexPrivate() {
        return String.format("%s(Hex:R=%02X,G=%02X,B=%02X,A=%02X)", this.name, NamedColor.d2i(this.awtColor.getRed()), NamedColor.d2i(this.awtColor.getGreen()), NamedColor.d2i(this.awtColor.getBlue()), NamedColor.d2i(this.awtColor.getAlpha()));
    }

    private String getNamePrivate() {
        return inUpperCase ? this.name.toUpperCase() : this.name;
    }
}

