/* M:/72_INP/02__Literals.jsh
Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó

Příkazy a úryvky zadávané ve výpisech v kapitole:
02  Základní datové typy a jejich literály
/*************************************************************************/


/*
** Výpis X.0: Inicializace
********************************************************************/
/********************************************************************


/**Výpis 2.1: Literály typu boolean
********************************************************************/
false   //NE, neplatí, nepravda, ...
true    //ANO, platí, pravda, ...
/********************************************************************


/*
** Výpis 2.2: Literály typu int v různých číselných soustavách
********************************************************************/
0b1_0111    //23 = 1*16 + 0*8 + 1*4 + 1*2 + 1*1 = 0x17
0B10_111    //027 - Číslo upravené pro převod na osmičkové
027         //Stejné číslo zapsané v osmičkové soustavě
0x17        //Stejné číslo zapsané v šestnáctkové soustavě
08          //Začíná nulou, ale obsahuje příliš velkou číslici
Ox17   //Začíná písmenem O => není to číslo, ale identifikátor
/********************************************************************


/*
** Výpis 2.3: Literály typu long
********************************************************************/
0L              //Nula typu long
1_234_567_890   //Vejde se do typu int
9_876_543_210   //Chyba: Nemá příponu a na int moc velké
9_876_543_210L  //Správně zapsané číslo typu long
/********************************************************************


/*
** Výpis 2.4: Různé způsoby zadání literálů typu double
********************************************************************/
9_876_543_210D  //Stejné jako minule, ale nyní typu double
0D              //Nula typu double
0.012345        //Zápis s pevnou řádovou (desetinnou) tečkou
12345e-6        //Totéž číslo zapsané v exponentovém tvaru
123.45e67       //Trochu větší číslo
/********************************************************************


/*
** Výpis 2.5: Literály typu float
********************************************************************/
123.45e6F   //Číslo typu float
0f          //Nula typu float
/********************************************************************


/*
** Výpis 2.6: Literály typu char
********************************************************************/
'\u263A'    //Znak "usměváček" - ?
'\u00AB'    //Znak '«' - 0xAB = 0b1010_1011 = 0b10_101_011 = 0253
'\u00bB'    //Znak '»' - ukázka, že nezáleží na velikosti písmen
'\253'      //Znak '«' zapsaný v osmičkové soustavě
'"'         //Znak uvozovek zadaný přímo
'\"'        //Znak uvozovek zadaný přes escape sekvenci
/********************************************************************


/*
** Výpis 2.7:	Načtení interního zabudovaného skriptu definujícího metody pro tisk
********************************************************************/
/open PRINTING
/methods
String s = "Definice a inicializace proměnné s typu String.";
/********************************************************************


/*
** Výpis 2.8: Literály typu String
********************************************************************/
s = "Text v \"uvozovkách\" a \'apostrofech'"
println(s)    //Tisk právě definovaného stringu
s = "První řádek\nDruhý řádek\nTřetí řádek"
println(s)
s = "První část dlouhého textu rozděleného do více částí" +
"\nDruhá část onoho dlouhého textu" +
" - a třetí část";
println(s)
s = ("V současné době se doporučuje dávát operátory na začátek "
  +  "následujícího řádku.\nJShell upozorníte na pokračování tak, "
  +  "že celý součet uzavřete do závorek.");
println(s)
s = ""  //Prázdný string = string neobsahující žádné znaky
println("Před(" + s + ")za.")
"String, který na daném řádku nekončí
/********************************************************************


/*
** Výpis 2.9: Textové bloky
********************************************************************/
s = """Nějaký text"""
s = """
        <html>
          <body>
            <p>Hello, world</p>
          </body>
        </html>
        """
println(s)
s = """
   Počátek  -\
     prostředek    \
   -    konec    """
s = """
    \s Odsazený      \s
         Odsazenější \s"""
println(s)
s = """
          """
/********************************************************************


/*
** Výpis 2.10: Nestandardní hodnoty reálných typů
********************************************************************/
1.0 / 0   //Kladné nekonečno typu double
-1D / 0   //Záporné nekonečno typu double
0D / 0    //Neexistující hodnota (Not a Number) typu double
1F / 0    //Kladné nekonečno typu float
-1F / 0   //Záporné nekonečno typu float
0F / 0    //Neexistující hodnota (Not a Number) typu float
0 / 0     //U celých čísel způsobí dělení nulou chybu (vyhodí výjimku)
1e30F/1e-30f   //Stačí dělit velké číslo číslem dostatečně malým
1e300/1e-300   //U typu double je ono „dostatečně“ trochu větší
0 / 1.0    //Kladná nula
0 / -1D    //Záporná nula
0 / -1     //Celá čísla mají pouze jednu nulu
/********************************************************************


/*
** Výpis X.0: Popis
********************************************************************/
                                                               //SYNC
/* Kód je uložen v souboru:
M:/72_INP/XXX.java
*/
