/* M:/72_INP/06C_Remaining_operators.jsh
Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó

Příkazy a úryvky zadávané ve výpisech v kapitole:
06  Ostatní operátory
/*************************************************************************/


/*
** Výpis 6.0: Inicializace prostředí – definice pomocných metod a proměnných
********************************************************************/
/set start Start_06.jsh
/reset
/methods
/vars
/********************************************************************


/*
** Výpis 6.1: Porovnávání desetinných čísel
********************************************************************/
double d1 = 0.1,  d2 = 0.2,   d3 = 0.3;
boolean equal = ((d1 + d2) == d3);
double difference = (d1 + d2)  -  d3;
equal = Math.abs(d1+d2 - d3) < 1e-15;
/********************************************************************


/*
** Výpis 6.2: Porovnávání stringů
********************************************************************/
String sd1 = "Dobrý",  sd2 = " den";
String s1 = "Dobrý den",  s2 = sd1 + sd2,  s3 = "Dobrý" + " " + "den";
boolean p12 = s1==s2,  p13 = s1==s3,  p23 = s2==s3;
p12 = s1.equals(s2);   p13 = s1.equals(s3);   p13 = s1.equals(s3);
/********************************************************************


/*
** Výpis 6.3: Podmíněné (zkrácené) a nepodmíněné logické operátory
********************************************************************/
boolean yes()  { println("Prováděno yes()");  return true; }
boolean no()  { println("Prováděno no()");   return false; }
no() || yes();  //Vyhodnotí se obě metody
yes() || no();  //Vyhodnotí se jen prvá, druhá není potřeba
yes() | no();  //Nezkrácené vyhodnocení => vyhodnotí se obě
yes() && no();  //Vyhodnotí se obě metody
no() && yes();  //Vyhodnotí se jen prvá, druhá není potřeba
no() & yes();  //Nezkrácené vyhodnocení => vyhodnotí se obě
/********************************************************************


/*
** Výpis 6.4: Přípravné úryvky
********************************************************************/
short s35AC = 0x35AC;   //Deklarace proměnné, se kterou budeme operovat
~s35AC;   //Výsledek bitových operací nad hodnotami malých typů je int
void prln(int x) { println(toIntBin(s35AC) + " = 0x0000_35AC = "
          + s35AC + '\n' + toIntBin(x)     + " = " + toIntHex(x)
                                           + " = " + x); }
prln(0xFF0);    //Číslo 0xFF0 budeme používat jako druhý operand
/********************************************************************


/*
** Výpis 6.5: Bitové logické operace
********************************************************************/
prln(~s35AC);  //Bitová negace - bity výsledku jsou negací původních
prln(s35AC & 0xFF0);  //Konjunkce jednotlivých bitů
prln(s35AC | 0xFF00);  //Disjunkce jednotlivých bitů
prln(s35AC ^ 0xFF00);  //XOR jednotlivých bitů
/********************************************************************


/*
** Výpis 6.6: Bitové posunové operace
********************************************************************/
prln(s35AC << 4); //Posun bitů o 4 vlevo (ekvivalent násobení 2^4=16)
prln(s35AC * 16);   //Násobení čísla číslem 2^4 = 16
prln(s35AC >> 4);   //Posun bitů o 4 vpravo (ekvivalent dělení 2^4)
prln(s35AC / 16);   //Celočíselné dělení čísla číslem 2^4 = 16
/*Čistý posun vrátí pro kladné číslo stejný výsledek jako znaménkový
*/ prln(s35AC >>> 4);
s35AC = (short)-s35AC; //Změním znaménko pro demo záporných čísel
/* Běžný (znaménkový) posun (ekvivalent dělení) zachová znaménko
*/ prln(s35AC >> 4);
prln(s35AC >>> 4); //Čistý posun nuluje nejvyšší bit
/********************************************************************


/*
** Výpis 6.7: Složené přiřazovací operátory
********************************************************************/
_byte = 5;          //Zatím tam bylo nula, tak aby bylo vidět změnu
_byte += _byte;     //Ekvivalentní příkaz nám ve výpisu 4.8 neprošel
println(_byte);     //Předchozí ohlašoval pomocnou proměnnou
_int = 100 * 3.14;  //Bez explicitního přetypování neprojde
_short = 100;       //Zatím tam byla nula
_short *= 3.14;     //Násobení celého čísla reálným
println(_short);    //Aby bylo opět vidět změnu hodnoty
/********************************************************************


/*
** Výpis 6.8: Ternární operátor
********************************************************************/
String ternary(boolean condition)
{
    return "Podmínka " + (condition  ?  "platí"  :  "neplatí");
}
println('+' + ternary(1>2) + "\n-" + ternary(2 > 1));
String ternary(boolean c1, boolean c2)
{
    String result = "Platnost: " + (c1  ?  (c2  ?  "ANO, ANO"
                                                :  "ANO, NE")
                                        :  (c2  ?  "NE, ANO"
                                                :  "NE, NE" ))
                                 + ((c1 & c2)   ?  ""  :  "\n");
    return result;
}
println(ternary(false, false) + ternary(false, true)
      + ternary(true,  false) + ternary(true,  true));
String ternary(double d) {
    String signum = (d < 0)  ?  "záporné"
                  : (d == 0) ?  "nula"
                  : (d > 0)  ?  "kladné"
                  : "NaN";
    return "Číslo " + d + " je " + signum + '\n';
}
println(ternary(-1) + ternary(0) + ternary(1) + ternary(0D/0)
                    + ternary(1.0/0) + ternary(-1.0/0) );
/********************************************************************


/*
** Výpis 6.9: Definice metody equal(double,double)
 *            porovnávající reálná čísla
********************************************************************/
boolean equal(double d1, double d2)
{
    boolean result = ((d1 - d2) == 0)  ?  true
                   : (d1 == 0)         ?  false //Abych nedělil nulou
                   : Math.abs((d1 - d2) / d1) < 1e-10;
    return result;
}
/********************************************************************


/*
** Výpis 6.10: Využití přepínače (výrazu switch) v definicích metod
**             pro výpočet počtu dní v zadaném měsíci
********************************************************************/
int modulo(int divident, int divisor)
{
    return (divident % divisor == 0)  ?  1  :  0;
}
int monthDays (int monthNum, int year)
{
    return switch (monthNum)  {
        case 1, 3, 5, 7, 8, 10, 12 -> 31;
        case 4, 6, 9, 11           -> 30;
        case 2 -> 28 + modulo(year, 4)
                     - modulo(year,100) + modulo(year,400);
        default -> -1;
    };
}
int monthDays (String month, int year)
{
    return switch (month.toLowerCase())  {
        case "leden", "březen", "květen",
             "červenec", "srpen", "říjen", "prosinec":  yield 31;

        case "duben", "červen", "září", "listopad":     yield 30;

        case "únor":
            int LeapYear = modulo(year, 4) - modulo(year,100)
                                           + modulo(year,400);
            yield 28 + LeapYear;

        default: yield -1;
    };
}
/********************************************************************


/*
** Výpis 6.11: Operátor instanceof
********************************************************************/
0 instaceof Object;      //Levý operand musí být objekt
(Object)0 instaceof Object;  //Prosté přetypování nepomůže
_Object = 0; //Vyrobil se objekt obalující zadanou primitivní hodnotu
_Object instanceof Object;  //Je v ní odkaz na objekt => projde
_Object.getClass()  //Ptáme se objektu na jeho mateřskou třídu
_Object instanceof String;  //Není v ní odkaz na String => neprojde
_Object = "xxx";  //Když do ní ale takový odkaz uložíme, ...
_Object instanceof String;  //test projde <= testuje skutečný typ
"xxx" instanceof String; //Test literálu neukáže nic, co bych nevěděl
_Object = null;  //Oficiálně je null instancí všech objekt. typů,
_Object instanceof Object; //ale pro instanceof není instancí žádného
/********************************************************************


/*
** Výpis 6.12: Ukázka použití shody vzorů pro operátor  instanceof
********************************************************************/
String lengthOld(Object o)
{
    return (o instanceof String)
         ? "Délka je " + ((String)o).length() + " znaků."
         : "Objekt " + o + " není textový řetězec.";
}
String lengthNew(Object o)
{
    return (o instanceof String s)
         ? "Délka je " + s.length() + " znaků."
         : "Objekt " + o + " není textový řetězec.";
}
/********************************************************************


/*
** Výpis 6.13: Operátor new
********************************************************************/
_Object = new Object();  //Nový obecný objekt
_Object = new String();  //Bezparametrický konstr. => prázdný string
_String = new String("text");  //Nová instance, ale stejný text
_Object == "";  //Stejný text, ale různé instance
_String == "text";  //Stejný text, ale různé instance
new Object  //Nečeká na závorky, ohlásí chybu
(new Object  //Vložením do závorek jsme jej přinutili čekat, ...
());         //... než závorky uzavřeme
/********************************************************************


/*
** Výpis 6.14: Priority operátorů
********************************************************************/
"Podmínka " + ((1<2)  ?  "platí"  :  "neplatí");
"Podmínka " + (1<2)  ?  "platí"  :  "neplatí";
/********************************************************************


/*
** Výpis 6.15:	Ukázky použití stringových šablon
********************************************************************/
//M:\72_INP>C:\_PGM\Java\JDK_JRE\JDK_21\bin\jshell.exe --enable-preview -v
String s = STR . "Jen literál";
s = STR."Předchozí byl: «\{s}»";
/open PRINTING
println(STR."""
        První řádek: \{s + s     /* Prosté zdvojení */ }
        Druhý řádek: \{s.toUpperCase() //Volání funkce
                      }""");
var t = "\{99}";
/********************************************************************


/*
** Výpis X.0: Popis
********************************************************************/
                                                               //SYNC
/* Kód je uložen v souboru:
M:/72_INP/XXX.java
*/
