/* M:/72_INP/08C_Conditions.jsh
Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó

Příkazy a úryvky zadávané ve výpisech v kapitole:
08  Rozhodování
/*************************************************************************/


/*
** Výpis 8.0: Inicializace prostředí – definice pomocných metod a proměnných
********************************************************************/
/set start Start_07.jsh
/reset
/methods
/vars
/********************************************************************


/*
** Výpis 8.1:	Jednoduchý podmíněný příkaz
********************************************************************/
String demoIf(boolean b)
{
    String result = "Podmínka";
    if (!b) result += " není";
    result += " splněna";
    return result;
}
println(demoIf(true));
println(demoIf(false));
/********************************************************************


/*
** Výpis 8.2:	Blok příkazů
********************************************************************/
void printSqrt(double number)   //Tiskne druhou odmocninu zadaného čísla
{
    if (number < 0) {
        println("Odmocňované číslo nesmí být záporné!");
        return;
    }
    double result = Math.sqrt(number);
    println("Odmocnina z čísla " + number + " = " + result);
}
printSqrt(2);
printSqrt(-2);
/********************************************************************


/*
** Výpis 8.3:	Vnořování bloků a používání lokálních proměnných
*********************************************************************/
void localInBlock(int request)
{
    int level = 0; //Hladina zanoření
    println("Nacházíme se ve vnějším bloku - hladina=" + level);
    if (request > 0 )
    {
        int first = ++level;
        println("  Vnitřní blok - hladina=" + first);
        int second;
//        println("  Neinicializovaná => nepoužitelná: " + second);
        if (request > 1)
        {
            second = ++level;
            println("    Vnitřnější blok - hladina=" + level
                    + "(" + second + "/" + first + ")");
            {
                //Jen si tu na chvíli něco deklaruji
                int third = ++level;
                println("      Nejvnitřnější blok - hladina=" + level
                    + "(" + third + "/" + second + "/" + first + ")");
                level--;
            }
            println("    Za nejvnitřnějším blokem - hladina=" + level);
            println("    First:  Deklarovaná a inicializovaná ve vnějším "
                      + "bloku => použitelná: " + first);
            println("    Second: Deklarovaná ve vnějším bloku, "
                      + "inicializovaná zde => použitelná: " + second);
            println("    Third:  Deklarovaná ve vnitřním bloku => "
                      + "nedosažitelná");
//            println( third);
            --level;
        }
        println("Za vnitřnějším blokem - hladina=" + level);
        println("  First: Deklarovaná a inicializovaná v tomto bloku "
                + "=> použitelná: " + first);
        println("  Second: Deklarovaná v tomto bloku, ale inicializovaná "
              +                                   "v podmíněném příkazu\n"
              + "          => inicializace není jistá => nepoužitelná");
//        println(second);
        level--;
    }
    println("Za vnitřním blokem zpět ve vnějším bloku - hladina=" +level);
    println("First: Deklarovaná ve vnitřním bloku => nedosažitelná");
//    println(first);
}
/********************************************************************


/*
** Výpis 8.4:	Volání metody definované ve výpisu 8.3
********************************************************************/
localInBlock(0);
localInBlock(2);
/********************************************************************


/*
** Výpis 8.5:	Lokalita proměnné vytvořené operátorem instanceof
********************************************************************/
void io1(Object o) {
    if (o instanceof String s) {
        println("io1: " + s.repeat(3));
    }
    println("io1: Argument=" + o + "proměnná s=" + s);
}
void io2(Object o) {
    if (! (o instanceof String s) ) {
        println("io2: Argument není string: " + o);
        return;
    }
    println("io2: " + s.repeat(3));
}
io2(123);   io2("-X-");
var s = "Externí";   io1("-X-");   io1(123)
/********************************************************************


/*
** Výpis 8.6:	Použitelnost proměnné vytvořené operátorem instanceof
** 				v rámci výrazu
********************************************************************/
void io3(Object o) {
    if (o instanceof String s   &&   s.length() < 5) {
        println("io3: String \"" + s + "\" je příliš krátký");
        return;
    }
    println("io3: Argument neřešen: " + o);
}
io3("nic");   io3("Delší string");   io3(123);
void io4(Object o) {
    if (o instanceof String s   ||   s.length() < 5) {
        println("PROŠLO:   Argument=" + o + ",   proměnná s=" + s);
        return;
    }
    println("NEPROŠLO: Argument=" + o + ",   proměnná s=" + s);
}
io4("ANO");   io4("Dlouhý");
/********************************************************************


/*
** Výpis 8.7:	Úplný podmíněný příkaz
********************************************************************/
void plusminus(int number)
{
    if (number >= 0) {
        println("Hodnota je nezáporná: " + number);
    }
    else {
        println("Hodnota je záporná: " + number);
    }
}
plusminus(-1);plusminus(0);plusminus(+1);
/********************************************************************


/*
** Výpis 8.8:	Zanořování příkazů při výběru z více možností
********************************************************************/
boolean možnost_1, možnost_2, možnost_3;
void odsazovaně() {//<-Není v knize, použita obalová metoda kvůli JShell
//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
if (možnost_1) {
    //Reakce na první možnost
}
else {
    if (možnost_2) {
        //Reakce na druhou možnost
    }
    else {
        if (možnost_3) {
            //Reakce na třetí možnost
        }
        else {
           //Zbylé možnosti
        }
    }
}
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
}  //<-Není v knize, použita obalová metoda kvůli JShell
/********************************************************************


/*
** Výpis 8.9:	Doporučené formátování při výběru z více možností
********************************************************************/
void doporučené() {//<-Není v knize, použita obalová metoda kvůli JShell
//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
if (možnost_1) {
    //Reakce na první možnost
}
else if (možnost_2) {
    //Reakce na druhou možnost
}
else if (možnost_3) {
    //Reakce na třetí možnost
}
else {
    //Zbylé možnosti
}
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
}  //<-Není v knize, použita obalová metoda kvůli JShell
/********************************************************************


/*
** Výpis 8.10:	Definice metody sqrt(double,double,double)
 *				řešící kvadratickou rovnici
********************************************************************/
void sqrt(double a, double b, double c)
{
    println("Rovnice " + a + "*x^2 + " + b + "*x + " + c + " = 0");
    double discriminant = b * b  - 4 * a * c;
    double a2 = 2 * a;
    if (discriminant > 0) {
        double sqrd = Math.sqrt(discriminant);
        double x1 = (-b - sqrd) / a2;
        double x2 = (-b + sqrd) / a2;
        println("má dvě reálná řešení: x1 = " + x1
            + "\n                      x2 = " + x2);
    }
    else if (discriminant == 0) {
        double x12 = -b / a2;
        println("má dvojnásobné řešení: x12 = " + x12);
    }
    else {
        double re = -b / a2;
        double im = Math.sqrt(-discriminant) / a2;
        println("má komplexní řešení: x = " + re + " ± " + im + "i");
    }
}
/********************************************************************


/*
** Výpis 8.11:	Volání metody sqrt(double,double,double)
 * 				řešící kvadratickou rovnici
********************************************************************/
sqrt(1, 0,-9);
sqrt(1, 2, 1);
sqrt(1, 0, 9);
/********************************************************************


/*
** Výpis 8.12:	Koncepce přepínače (příkazu switch) převzatá z jazyka C
********************************************************************/
enum KH {konstantní_hodnota_1, konstantní_hodnota_2, KH_1, KH_2};
KH výraz;
void starý_switch() {//<-Není v knize, použita obalová metoda kvůli JShell
//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
switch (výraz)
{
   case konstantní_hodnota_1:
       //Akce, která se má spustit, má-li výraz hodnotu hodnota_1
       break;

   case konstantní_hodnota_2:
       //Akce, která se má spustit, má-li výraz hodnotu hodnota_2
       break;

    //...   Další možné větve

    default:     //Tato část je nepovinná
        //Akce spouštěná v případě, kdy výsledkem výrazu
        //není žádná z výše vyjmenovaných hodnot.
}
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
} //<-Není v knize, použita obalová metoda kvůli JShell
/********************************************************************


/*
** Výpis 8.13:	Novější koncepce přepínače (příkazu switch)
********************************************************************/
void nový_switch() {//<-Není v knize, použita obalová metoda kvůli JShell
//vvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvvv
switch (výraz)
{
   case KH_1 -> print("Vykonat při hodnotě KH_1.");

   case KH_2 -> {
       print("Vykonat při hodnotě KH_2.");
       print("Složitější akce je třeba uzavřít do bloku kódu,");
       print("aby se z nich stal jeden, byť složitější, příkaz");
   }

    //...   Další možné větve

    default -> print("Jiná hodnota proměnné výraz");
}
//AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
} //<-Není v knize, použita obalová metoda kvůli JShell
/********************************************************************


/*
** Výpis 8.14:	Ukázka použití klasické verze přepínače (příkazu switch)
********************************************************************/
void sDemo(String day)
{
    String start = " - Pracuji ",  level = "téměř ",  add = "";
    switch(day)
    {
        default:
            println(day + " - Je víkend => nepracuje se");
            break;
        case "PONDĚLÍ":
            println(day + start + "zvolna, vzpamatovávám se z víkendu");
            break;
        case "STŘEDA":
            level = "";
            add = "\n         Den s nejkvalitnějšími výrobky";
        case "ÚTERÝ":
        case "ČTVRTEK":
            println(day + start + level + "naplno" + add);
            break;
        case "PÁTEK":
            println(day + start + "zvolna, už se těším na víkend");
            break;
    }
}
/********************************************************************


/*
** Výpis 8.15:	Volání metody využívající přepínač
********************************************************************/
{sDemo("PONDĚLÍ"); sDemo("ÚTERÝ");  sDemo("STŘEDA"); sDemo("ČTVRTEK");
 sDemo("PÁTEK");   sDemo("SOBOTA"); sDemo("NEDĚLE");}
/********************************************************************


/*
** Výpis 8.16:	Ukázka použití novější verze přepínače (příkazu switch)
********************************************************************/
void nDemo(String day)
{
    String start = " - Pracuji ",  add = "téměř naplno";
    switch(day)
    {
        default -> { start = "";
                     add   = " - Je víkend => nepracuje se";
                   }
        case "PONDĚLÍ" -> add = "zvolna, vzpamatovávám se z víkendu";
        case "STŘEDA"  -> { add = "naplno\n         " +
                                  "Den s nejkvalitnějšími výrobky";
            }
        case "ÚTERÝ", "ČTVRTEK" -> {}
        case "PÁTEK" -> add = "zvolna, už se těším na víkend";
    }
    println(day + start + add);
}
/********************************************************************


/*
** Výpis 8.17:	Volání metody využívající novější verzi přepínače
********************************************************************/
{nDemo("PONDĚLÍ"); nDemo("ÚTERÝ");  nDemo("STŘEDA"); nDemo("ČTVRTEK");
 nDemo("PÁTEK");   nDemo("SOBOTA"); nDemo("NEDĚLE");}
/********************************************************************


/*
** Výpis X.0: Popis
********************************************************************/
                                                               //SYNC
/* Kód je uložen v souboru:
M:/72_INP/XXX.java
*/
