/* M:/72_INP/17a_Reports17.jsh
Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
*/


/*********************************************************************
 * Metoda pro výpis zprávy konstruktoru o typu konstruovaného objektu
 * spolu s typem aktuálně konstruovaného podobjektu.
 *
 * @param instance Instance výsledného konstruovaného objektu
 * @param cls      Class-objekt třídy volajícího konstruktoru
 */
void constructorReport(Object instance, Class<?> cls)
{
    Class<?> instanceCls = instance.getClass();
    boolean  topType     = instanceCls.equals(cls);
    String callingClass  = cls        .getSimpleName();
    String instanceClass = instanceCls.getSimpleName();
    String indent        = "                        "
                         .substring(0, callingClass.length()+2);
    System.out.println(callingClass + ": Vytvářím " + instance + "\n"+
        (topType ? ""
                 : indent + "jako rodičovský podobjekt objektu typu " +
                   instanceClass));
}


/*********************************************************************
 * Pomocná metoda -- vytiskne argument na standardní výstup
 * a vrátí jej jako funkční hodnotu.
 *
 * @param input Tištěný a vracený objekt
 * @return Argument
 */
String intermezzo(String input)
{
    System.out.println(input);
    return input;
}


/*********************************************************************
 * Vytiskne podpis argumentu na standardní výstup.
 *
 * @param object Tištěný objekt
 */
void println(Object object)
{
    System.out.println(object);
}


/*************************************************************************/
