/* M:/72_INP/21C_Exceptions.jsh
Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó

Příkazy a úryvky zadávané ve výpisech v kapitole:
21  Výjimky a aserce
/*************************************************************************/


/*
** Výpis 21.0:	Inicializace
********************************************************************/
/********************************************************************


/*
** Výpis 21.1:	Ukázka vyhození výjimky v prostředí JShell
********************************************************************/
throw new RuntimeException();
void throwing()
{
    throw new RuntimeException("Cvičně vyhazovaná výjimka");
}
throwing();
/********************************************************************


/*
** Výpis 21.2:	Definice metody cleanUpFirst() oddělující
** 				vytvoření a vyhození výjimky
********************************************************************/
void cleanUpFirst()
{
    System.err.println("Obstarávám prostředky");
    System.err.println("Začínám vykonávat požadovanou operaci");
    RuntimeException rex = new RuntimeException(
            "\nOperace zhavarovaly protože ...");
    System.err.println("Už je uklizeno, může se vyhazovat");
    throw rex;
}
cleanUpFirst();
/********************************************************************


/*
** Výpis 21.3:	Metoda unreachable() demonstrující nedosažitelnost kódu
** 				za vyhozením výjimky
********************************************************************/
void unreachable() {
    System.err.println("Před vyhozením výjimky");
    throw new RuntimeException("\nZa mnou už se nic neudělá");
    System.err.println("Po vyhození výjimky");
}
/********************************************************************


/*
** Výpis 21.4:	Demonstrace zachycení vyhozené výjimky
********************************************************************/
void exceptionCatching(int level)
{
    System.out.println("+++++ Příchod na hladinu "  + level);
    int breaker = 1 / level;
    System.out.println("      Dělení v hladině " + level + " se povedlo");
    try {
        exceptionCatching(level - 1);
    }catch(RuntimeException rex) {
        System.out.println("xxxxx V hladině " + level + " přišla " + rex);
//        rex.printStackTrace(System.out);
    }
    System.out.println("----- Konec akce v hladině " + level);
}
exceptionCatching(2);
/********************************************************************


/*
** Výpis 21.5:	Demonstrace více bloků catch + bloku finally
********************************************************************/
void multiThrow(int h)
{
    if (h<0) { throw new Error("CHYBA - Podteklo to"); }
    int    h0 = 1 / h;                  //h=0 => ArithmeticException
    String h7 = (h%3 == 0) ?  null  :  "";
           h7.toString();               //h=3 => NullPointerException
    char   hM = "ABCDEF".charAt(h + 3); //h>1 => IndexOutOfBoundsException
    System.out.println("      Pro h=" + h + " metoda multiThrow prošla");
}
void catchTest(int level)
{
    System.out.println("+++++ Příchod na hladinu "  + level);
    String zpráva =    "      Hladina " + level + ": ";
    try {
        multiThrow(level);
        zpráva += "Test v pořádku";
    }
    catch(ArithmeticException | NullPointerException  e)
    {
        zpráva += "Nastala výjimka typu " + e;
    }
    catch(IndexOutOfBoundsException e) {
        zpráva += "Index mimo meze";
    }
    catch(RuntimeException e) {
        zpráva += "Někde se stala chyba typu " + e.getClass().getSimpleName();
    }
    catch(Throwable e) {
        zpráva += "Něco se stalo - " + e.getClass().getName()
               + "\n      Příčina: " + e.getMessage();
        throw new RuntimeException("Utíkám z hladiny " + level);
    }
    finally {
        System.out.println(zpráva);
    }
    System.out.println("----- Konec akce v hladině " + level);
    catchTest(level-1);
}
/********************************************************************


/*
** Výpis 21.6:	Reakce prostředí JShell po zadání příkazu catchTest(4)
********************************************************************/
catchTest(4);
/********************************************************************


/*
** Výpis 21.7:	Definice výjimek CheckedException a UncheckedException
********************************************************************/
public class CheckedException extends Exception
{
    public CheckedException()                            { super(); }
    public CheckedException(String msg)                  { super(msg); }
    public CheckedException(            Throwable cause) { super(cause); }
    public CheckedException(String msg, Throwable cause) { super(msg, cause); }
}
public class UncheckedException extends RuntimeException
{
    public UncheckedException()                            { super(); }
    public UncheckedException(String msg)                  { super(msg); }
    public UncheckedException(            Throwable cause) { super(cause); }
    public UncheckedException(String msg, Throwable cause) { super(msg, cause); }
}
/********************************************************************


/*
** Výpis 21.8:	Metody demonstrující práci s kontrolovanými
 * 				a nekontrolovanými výjimkami
********************************************************************/
/** Metoda, která může vyhodit kontrolovanou výjimku, to musí hlásit.
*/  void throwsChecked() throws CheckedException {
        throw new CheckedException("Kontrolovaná výjimka");
    }
/** Vyhazování nekontrolované výjimky se hlásit nemusí...
*/  void throwsUnchecked_() {
        throw new UncheckedException("Nekontrolovaná výjimka");
    }
/** ... ale může.
*/  void throwsUnchecked() throws UncheckedException {
        throw new UncheckedException("Nekontrolovaná výjimka");
    }
/** Neohlášení možného vyhození kontrolované výjimky je syntaktická chyba.
*/  void callThrowingMtd_(boolean perform) {
        if (perform) { throwsChecked(); }
    }
/** Jakmile možné vyhození deklaruji, překladač se uklidní.
*/  void callThrowingMtd(boolean perform) throws CheckedException {
        if (perform) { throwsChecked(); }
        throwsUnchecked();   //Toto hlásit nemusím
    }
/** Když výjimku zachytím a nehrozí, že ji vyhodím dál, nic nehlásím.
*/  void exceptionChecked() {
        try {
            throwsChecked();
        }
        catch(CheckedException e) {
            System.out.println("Ošetřena kontrolovaná výjimka: " + e);
        }
    }
/********************************************************************


/*
** Výpis 21.8x: Volání metod z předchozího výpisu
********************************************************************/
/*{
    try {
        callThrowingMtd(true);
        callThrowingMtd(false);
        exceptionChecked();
    } catch(Exception e) {}
}*/
/********************************************************************


/*
** Výpis 21.9:	Definice metody conversion() převádějící kontrolovanou
** 				výjimku na nekontrolovanou
********************************************************************/
public static void conversion()
{
    try {
        throwsChecked();
    } catch(CheckedException e) {
        throw new UncheckedException("Nečekaně vyhozená výjimka", e);
    }
}
/********************************************************************


/*
** Výpis 21.10:	Definice třídy Exceptions demonstrující výpis obsahu ZNA
** 				u výjimek znajících svého původce
********************************************************************/
/* Kód je uložen v souboru:
M:/72_Java/b72_j21ref/c21_exceptions/Exceptions.java
*/
/********************************************************************


/*
** Výpis 21.11:	Chybové hlášení po spuštění třídy Exceptions z výpisu 21.10
** 				z příkazového řádku
********************************************************************/
/********************************************************************


/*
** Výpis 21.12: Definice třídy AssertDemo pro demonstraci funkce příkazu assert
********************************************************************/
/* Kód je uložen v souboru:
M:/72_Java/b72_j21ref/c21_exceptions/AssertDemo.java
*/
/********************************************************************


/*
** Výpis 21.13:	Reakce třídy AssertDemo při různých spuštěních
********************************************************************/
/********************************************************************


/*
** Výpis 21.14:	Definice metody getCallerName(int,int) ve třídě CallerReporter
********************************************************************/
/*Definice:
M:/72_LibSrc/ruplib/dbg/CallerReporter.java
*/
/********************************************************************


/*
** Výpis	21.0: Popis
********************************************************************/
                                                               //SYNC
/* Kód je uložen v souboru:
M:/72_INP/XXX.java
*/
