//Soubor: Start_26.jsh
//################################## Příliš žluťoučký kůň úpěl ďábelské ódy

// /env -class-path ../72_LIB/RUP_Lib.jar
/env -class-path ../_72_IDEA_Java20/out/production/_72_IDEA_Java20

import java.util.*;
import java.util.function.*;
import java.util.regex.*;
import java.util.stream.*;

import ruplib.canvas.*;
import ruplib.geom.*;
import ruplib.util.*;


/***************************************************************************
 * Klon metody ze standardní knihovny.
 *
 * @param obj Objekt, jehož textová podoba se má vytisknout
 */ void println(Object obj)
{
    System.out.println(obj);
}


/***************************************************************************
 * Klon metody ze standardní knihovny.
 *
 * @param obj Objekt, jehož textová podoba se má vytisknout
 */ void print(Object obj)
{
    System.out.print(obj);
}


/**************************************************************************
 * Převede obsah dvourozměrného pole na textový řetězec tak, že
 * na první řádek vypíše zadaný titulek
 * a na každý další pak hodnotu prvku pole.
 */ String arr1toStringln(String title, Object[] arr1)
{
    var stream    = Stream.of(arr1).map(o -> o.toString());
    var collector = Collectors.joining("\n   ", title + "\n   ", "");
    var result    = stream.collect(collector);
    return result;
}


/**************************************************************************
 * Převede obsah dvourozměrného pole na textový řetězec tak, že
 * na první řádek vypíše zadaný titulek
 * a na každý další pak jeden řádek pole uvozený indexem daného řádku.
 */ String arr2toString(String title, Object[][] arr2)
{
    StringBuilder sb = new StringBuilder(title);
    int index = 0;
    for(Object[] row : arr2) {
        sb.append('\n');
        sb.append(String.format("%3d: ", index++));
        sb.append(Arrays.toString(row));
    }
    return sb.toString();
}


/**************************************************************************
 * Vytiskne název zadané třídy následovaný signaturami
 * atributů, konstruktorů a veřejných metod zadané třídy.
 * Seznam neobsahuje metody, které jsou pouze zděděné, ale nepřebité.
 */ void printFCM(Class<?> cls)
{
    var fields       = cls.getDeclaredFields();
    var constructors = cls.getConstructors();
    var methods      = cls.getDeclaredMethods();
    var stream = Stream.concat(Arrays.stream(fields),
                 Stream.concat(Arrays.stream(constructors),
                               Arrays.stream(methods)))
                .map(o -> o.toString());
    var collector = Collectors.joining("\n   ",
                    "\nAtributy, konstruktory a veřejné metody třídy "
                  + cls.getSimpleName() + "\n   ",
                    "");
    var result = stream.collect(collector);
    result = result.replaceAll("REPL.\\$JShell\\$.+\\$", "");
    println(result);
}


/**************************************************************************
 * Vytiskne název zadané třídy následovaný signaturami
 * atributů, konstruktorů a veřejných metod mateřské třídy zadané instance.
 * Seznam neobsahuje metody, které jsou pouze zděděné, ale nepřebité.
 */ void printFCM(Object o)
{
    printFCM(o.getClass());
}

/**************************************************************************
 * Vrátí informaci tom, shodují-li se zadané parametry
 * se zadanou relativní přesností.
 * @param d1 První z porovnávaných hodnot
 * @param d2 Druhá z porovnávaných hodnot
 * @param precision Zadaná relativní přesnost
 */ boolean equalsDouble(double d1, double d2, double precision)
{
    double max = Math.max(Math.abs(d1), Math.abs(d2));
    double dif = (d2 - d1) / max;
    println("dif = " + dif);
    return Math.abs(dif) < precision;
}

/**Rekapitulace
**************************************************************************/
//#########################################################################
//save -history Start_26.jsh
/imports
/vars
/methods
/types
