package b72_j21ref.c15_interface;
/* M:/72_Java/b72_j21ref/c15_interface/DemoInterface.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */


/*******************************************************************************
 * Interfejs slouží jako demonstrační pro vysvětlení syntaxe.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public interface DemoInterface
{
//\CC== CLASS (STATIC) CONSTANTS ===============================================

    /** Všechny atributy získávají automaticky modifikátory public static. */
    String CONSTANT = "Konstanta implicitně statická a veřejná";

    /** Modifikátory sice napsat můžeme, ale pouze tyto. */
    public static String CONST_EXP = "Konstanta explicitně statická a veřejná";



//\CM== CLASS (STATIC) METHODS =================================================

    /***************************************************************************
     * Interfejs umožňuje definovat statické metody.
     * Není-li řečeno jinak, je metoda automaticky veřejná.
     */
    static void staticPublicMethod()
    {
        System.out.println("Veřejná statická metoda v interfejsu");
        staticPrivateMethod();
    }



//\CP== CLASS (STATIC) PRIVATE AND AUXILIARY METHODS ===========================

    /***************************************************************************
     * Interfejs nyní umožňuje definovat i soukromé statické metody.
     */
    private static void staticPrivateMethod()
    {
        System.out.println("   Soukromá statická metoda v interfejsu");
    }



//##############################################################################
//\AG== ABSTRACT GETTERS AND SETTERS ===========================================
//\AM== REMAINING ABSTRACT METHODS =============================================

    /***************************************************************************
     * Interfejs slouží primárně k deklaraci veřejných abstraktních metod.
     */
    public abstract void abstractMethodExp();

    /***************************************************************************
     * Metoda je veřejná a abstraktní, i když to není explicitně řečeno.
     */
    void abstractMethod();



//\DG== DEFAULT GETTERS AND SETTERS ============================================
//\DM== REMAINING DEFAULT METHODS ==============================================

    /***************************************************************************
     * Interfejs umožňuje definovat implicitní (defaultní) verze metod.
     */
    default void defaultMethod()
    {
        System.out.println("Implicitní instanční metoda v interfejsu");
        staticPrivateMethod();
        privateMethod();
    }


//\DP== DEFAULT INSTANCE PRIVATE AND AUXILIARY METHODS =========================

    /***************************************************************************
     * Interfejs umožňuje definovat i soukromé instanční metody.
     */
    private void privateMethod()
    {
        System.out.println("   Soukromá instanční metoda v interfejsu");
    }



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
