package b72_j21ref.c15_interface;
/* M:/72_Java/b72_j21ref/c15_interface/IInterfaceFull.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */


/*******************************************************************************
 * Demonstrační definice interfejsu obsahujícího všechny povolené druhy členů
 * s výjimkou typových.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public interface IInterfaceFull
{
    /** Všechny atributy získávají automaticky modifikátory public static. */
    String CONSTANT = "Konstanta je implicitně statická a veřejná";

    /** Modifikátory sice napsat můžeme, ale pouze public a static. */
    public static String CONST_EXP = "Konstanta explicitně statická a veřejná";

    /***************************************************************************
     * Interfejs umožňuje definovat statické metody,
     * a to včetně metody sloužící jako vstupní bod celé aplikace.
     * Není-li označena jako soukromá, je automaticky veřejná.
     *
     * @param args Argumenty příkazového řádku
     */
    static void main(String[] args)  {
        System.out.println("Veřejná statická metoda interfejsu");
        staticPrivateMethod();
    }

    /***************************************************************************
     * Interfejs umožňuje definovat i soukromé statické metody.
     */
    private static void staticPrivateMethod()  {
        System.out.println("   Soukromá statická metoda interfejsu");
    }

    /***************************************************************************
     * Metoda, která je pouze deklarovaná, je automaticky veřejná a abstraktní.
     */
    void abstractMethod();

    /***************************************************************************
     * Interfejs umožňuje definovat implicitní (defaultní) verze metod.
     * I ty jsou automaticky veřejné.
     */
    default void defaultMethod()  {
        System.out.println("Implicitní instanční metoda v interfejsu");
        staticPrivateMethod();
        privateMethod();
    }

    /***************************************************************************
     * Interfejs umožňuje definovat i soukromé instanční metody.
     */
    private void privateMethod()  {
        System.out.println("   Soukromá instanční metoda v interfejsu");
    }
}
