package b72_j21ref.c16_constructors;
/* M:/72_Java/b72_j21ref/c16_constructors/This.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */
import ruplib.dbg.IndentingReporter;



/*******************************************************************************
 * Testovací třída {@code ConstructorsTest} definuje sadu testů
 * pro experimenty s třídou {@link Constructors}.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class ConstructorsTest
{
//\CV== CLASS VARIABLES (VARIABLE CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** Zpravodaj zprostředkující odsazovaný tisk na standardní výstup. */
    private static IndentingReporter IR;



//##############################################################################
//\CP== CLASS (STATIC) PRIVATE AND AUXILIARY METHODS ===========================

    /***************************************************************************
     * Metoda nijak nepoužívá třídu {@link Constructors}.
     */
    private static void nothingNeeded()
    {
        IR.reportStart();
        print("Stačím si sama - byla jsem spuštěna a nikoho nepotřebuji.");
        IR.reportEnd();
    }


    /***************************************************************************
     * Metoda používá pouze třídu {@link Constructors},
     * nepracuje s jejími instancemi.
     */
    private static void classNeeded()
    {
        IR.reportStart();
        print("Potřebuji třídu - jdu žádat o class-objekt.");
        Object clso = Constructors.CLASS_OBJECT;
        Constructors.printStaticAttributes("Test: classNeeded");
        print("Obdržela jsem objekt: " + clso);
        IR.reportEnd();
    }


    /***************************************************************************
     * Metoda požaduje vytvoření instance třídy {@link Constructors}.
     */
    private static void instanceNeeded()
    {
        IR.reportStart();
        print("Potřebuji instanci - jdu o ni požádat.");
        Object inst = new Constructors();
        print("Obdržela jsem objekt: " + inst);
        IR.reportEnd();
    }


    /***************************************************************************
     * "Zarámuje" zadaný text a vytiskne jej na standardní výstup.
     *
     * @param text Tištěný text
     */
    private static void print(String text)
    {
        System.out.println("\nvvvvvvvvvvvvvvvvvvvvv\n" +
                           text +
                           "\n^^^^^^^^^^^^^^^^^^^^^");
    }


    /***************************************************************************
     * Metoda volá jednoparametrický konstruktor {@link Constructors},
     * a němž ví, že bude volat dvouparamerický a ten zase tříparametrický.
     * Metoda slouží pro výklad práce s debuggerem.
     */
    private static void testInvocation()
    {
        IR.reportStart();
        Constructors inst = new Constructors("Experiment");
        System.out.println("\n=================================" +
                           "\nVytvořená instance: " + inst +
                           "\n=================================");
        IR.reportEnd();
    }



//##############################################################################
//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ===================================

    /***************************************************************************
     */
    public ConstructorsTest()
    {
    }



//##############################################################################
//== MAIN METHOD ===============================================================

    /***************************************************************************
     * Metoda spouštějící celou aplikaci.
     *
     * @param args Parametry příkazového řádku
     */
    public static void main(String... args)
    {
        int testNo = 9;
        if ((args != null)  &&  (args.length > 0)  &&  !args[0].isEmpty())
        {
            try { testNo = Integer.parseInt(args[0]); }
            catch (NumberFormatException e) { /* Jako by byl nezadán. */ }
        }
        IR = IndentingReporter.getSystemReporter();

        switch (testNo)
        {
            case 0:  nothingNeeded();   break;
            case 1:  classNeeded();     break;
            case 2:  instanceNeeded();  break;
            default: testInvocation();  break;
        }

        IndentingReporter.returnSystemOut();
    }
}
