/* UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package b72_j21ref.c19_virtual;

import ruplib.canvas.Canvas;
import ruplib.canvas.Rectangle;
import ruplib.util.NamedColor;



/*******************************************************************************
 * Instance třídy {@code Square19} představují ...
 * The {@code Square19} class instances represent ...
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Square19 extends Rectangle
{
    /***************************************************************************
     * Připraví novou instanci s implicitním umístěním, rozměry a barvou.
     */
    public Square19()
    {
        this(0, 0, Canvas.getStep(), DEFAULT_COLOR);
    }

    /***************************************************************************
     * Připraví novou instanci se zadanou pozicí, implicitními rozměry
     * a implicitní barvou.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     */
    Square19(int x, int y)
    {
        this(x, y, Canvas.getStep());
    }

    /***************************************************************************
     * Připraví novou instanci se zadanou pozicí a rozměry
     * a implicitní barvou.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param size    Rozměr vytvářené instance,  size &gt; 0
     */
    Square19(int x, int y, int size)
    {
//        super(x, y, size, size);
//    //Tělo by bylo možno stejně dobře definovat příkazem
        this(x, y, size, DEFAULT_COLOR);
    }

    /***************************************************************************
     * Připraví novou instanci se zadanou pozicí, rozměry a barvou.
     * Pozice instance je přitom definována jako pozice
     * jejího levého horního rohu.
     * &nbsp;
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param size    Rozměr vytvářené instance,  size &gt; 0
     * @param color   Barva vytvářené instance
     */
    public Square19(int x, int y, int size, NamedColor color)
    {
        super(x, y, size, size, color);
    }



//\IG== INSTANCE GETTERS AND SETTERS ===========================================

//    // Výchozí nabídka od IDE
//    /***************************************************************************
//     * Nastaví nové rozměry instance.
//     * Rozměry instance jsou přitom definovány jako rozměry
//     * opsaného obdélníku.
//     * Nastavované rozměry musí být nezáporné,
//     * místo nulového rozměru se nastaví rozměr rovný jedné.
//     * @param width    Nově nastavovaná šířka; šířka &gt;= 0
//     * @param height   Nově nastavovaná výška; výška &gt;= 0
//     */
//    @Override
//    public void setSize(int width, int height)
//    {
//        super.setSize(width, height);
//    }


//    /** Verze hlídající dodržení (width == height). */
//    @Override
//    public void setSize(int width, int height)
//    {
//        if (width != height) {
//            width = -1;
//        }
//        super.setSize(width);
//    }


    /***************************************************************************
     * Nastaví nové rozměry instance.
     * Nastavovaná šířka a výška musejí mít stejnou velikost
     *
     * @param width    Nově nastavovaná šířka; šířka &gt;= 0
     * @param height   Nově nastavovaná výška; výška &gt;= 0
     * @throws IllegalArgumentException Nemá-li šířka a výška stejnou velikost
     */
    @Override
    public void setSize(int width, int height)
    {
        if (width != height) {
            width = -1;
        }
        super.setSize(width, width);
    }



//\IM== INSTANCE REMAINING NON-PRIVATE METHODS =================================

    /***************************************************************************
     * Vrátí kopii dané instance,
     * tj. stejně velkou a stejně umístěnou instanci stejné barvy.
     *
     * @return Požadovaná kopie
     */
    @Override
    public Square19 copy()
    {
        return new Square19(getX(), getY(), getWidth(), getColor());
    }



//##############################################################################
//\MM== MAIN METHOD ============================================================

    public static void main(String[] args)
    {
        Square19 sq = new Square19();
        sq.setSize(10, 20);
    }
}
