/* UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package b72_j21ref.c19_virtual;

import ruplib.dbg.IndentingReporter;



/*******************************************************************************
 * Instance třídy {@code TestVirtual} představují ...
 * The {@code TestVirtual} class instances represent ...
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class TestVirtual
{
//\CC== CLASS CONSTANTS (CONSTANT CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** Zpravodaj o volajících metodách. */
    private static IndentingReporter IR;



//##############################################################################
//\CP== CLASS (STATIC) PRIVATE AND AUXILIARY METHODS ===========================

    /***************************************************************************
     * Report objektů vydávajících se za matku.
     *
     * @param subject   Označení skutečné povahy objektu
     * @param mother    Objekt vydávající se za matku
     */
    private static void motherReport(String subject, Mother19 mother)
    {
        IR.reportStart(subject + " vydávající se za matku");
        mother.summaryMe();
        IR.reportEnd();
    }


    /***************************************************************************
     * Report objektů vydávajících se za dceru.
     *
     * @param subject   Označení skutečné povahy objektu
     * @param daughter  Objekt vydávající se za dceru
     */
    private static void daughterReport(String subject, Daughter19 daughter)
    {
        IR.reportStart(subject + " vydávající se za dceru");
        daughter.summaryDe();
        IR.reportEnd();
    }


    /***************************************************************************
     * Report objektů vydávajících se za vnučku.
     *
     * @param subject       Označení skutečné povahy objektu
     * @param granddaughter Objekt vydávající se za vnučku
     */
    private static void granddaughterReport(String subject,
                                            Granddaughter19 granddaughter)
    {
        IR.reportStart(subject + " vydávající se za vnučku");
        granddaughter.summaryGe();
        IR.reportEnd();
    }


    /***************************************************************************
     * Testuje volání virtuálních metod objektů v přípravku
     * prostřednictvím metod z rodiny {@code ???ExplReport}.
     */
    public static void testReportByRole()
    {
        Mother19        mother        = new Mother19();
        Daughter19      daughter      = new Daughter19();
        Granddaughter19 granddaughter = new Granddaughter19();

        IR.reportStart("Reporty objektů vydávajících se za matku"); {
            motherReport("Matka",  mother);
            motherReport("Dcera",  daughter);
            motherReport("Vnučka", granddaughter);
        }IR.reportEnd();
        IR.reportStart("Reporty objektů vydávajících se za dceru"); {
            daughterReport("Dcera",  daughter);
            daughterReport("Vnučka", granddaughter);
        }IR.reportEnd();
        IR.reportStart("Reporty objektů vydávajících se za vnučku");{
            granddaughterReport("Vnučka", granddaughter);
        }IR.reportEnd();
    }


    /***************************************************************************
     * Testuje volání virtuálních metod objektů v přípravku
     * prostřednictvím metod z rodiny {@code ???ExplReport}.
     */
    public static void testReportByMother()
    {
        Mother19        mother        = new Mother19();
        Daughter19      daughter      = new Daughter19();
        Granddaughter19 granddaughter = new Granddaughter19();

        IR.reportStart("Reporty instance matky"); {
            motherReport("Matka",  mother);
        }IR.reportEnd();
        IR.reportStart("Reporty instance dcery"); {
            motherReport  ("Dcera",  daughter);
            daughterReport("Dcera",  daughter);
        }IR.reportEnd();
        IR.reportStart("Reporty instance vnučky");{
            motherReport       ("Vnučka", granddaughter);
            daughterReport     ("Vnučka", granddaughter);
            granddaughterReport("Vnučka", granddaughter);
        }IR.reportEnd();
    }



//##############################################################################
//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ===================================

    /***************************************************************************
     */
    public TestVirtual()
    {
    }



//##############################################################################
//== MAIN METHOD ===============================================================

    /***************************************************************************
     * Metoda spouštějící celou aplikaci.
     *
     * @param args Parametry příkazového řádku
     */
    public static void main(String[] args)
    {
        IR = IndentingReporter.getSystemReporter();
        testReportByRole();
        System.out.println("################################################");
        testReportByMother();
    }
}
