/* The file is saved in UTF-8 codepage.
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package b72_j21ref.c22_generics;

import ruplib.geom.Direction8;



/*******************************************************************************
 * Instance třídy {@code DirectionGroup} představují prvky grupy
 * hlavních a vedlejších světových stran s operací otáčení.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class DirectionGroup implements IGroup<Direction8, DirectionGroup>
{
//== CONSTANT CLASS ATTRIBUTES =================================================

    /** Počet definovaných směrů s vyloučením směru ukazujícího nikam. */
    private static final int MODUL = Direction8.NUM_DIRS - 1;

    /** Neutrální prvek (identity element) dané grupy. */
    private static final DirectionGroup IDENTITY_ELEMENT =
                                        new DirectionGroup(Direction8.EAST);



//== VARIABLE CLASS ATTRIBUTES =================================================



//##############################################################################
//== STATIC INITIALIZER (CLASS CONSTRUCTOR) ====================================
//== CLASS GETTERS AND SETTERS =================================================
//== OTHER NON-PRIVATE CLASS METHODS ===========================================
//== PRIVATE AND AUXILIARY CLASS METHODS =======================================



//##############################################################################
//== CONSTANT INSTANCE ATTRIBUTES ==============================================

    /** Odpovídající směr. */
    private final Direction8 direction;



//== VARIABLE INSTANCE ATTRIBUTES ==============================================



//##############################################################################
//== CONSTRUCTORS AND FACTORY METHODS ==========================================

    /***************************************************************************
     * Vytvoří nový prvek grupy směrů.
     *
     * @param direction Směr zařazovaný do grupy
     */
    public DirectionGroup(Direction8 direction)
    {
        assert (direction != Direction8.NOWHERE) :
               "\nSměr NOWHERE nemůže být členem grupy";
        this.direction = direction;
    }



//== ABSTRACT METHODS ==========================================================
//== INSTANCE GETTERS AND SETTERS ==============================================

    /***************************************************************************
     * Vrátí prvek základního typu odpovídající danému grupovému prvku.
     *
     * @return Sdružený prvek
     */
    @Override
    public Direction8 getBaseElement()
    {
        return direction;
    }


    /***************************************************************************
     * Vrátí inverzní prvek k danému prvku.
     *
     * @return Inverzní prvek
     */
    @Override
    public DirectionGroup getInverseElement()
    {
        DirectionGroup inverse = new DirectionGroup(direction.aboutTurn());
        return inverse;
    }


    /***************************************************************************
     * Vrátí neutrální prvek dané grupy.
     *
     * @return Neutrální prvek
     */
    @Override
    public DirectionGroup getIdentityElement()
    {
        return IDENTITY_ELEMENT;
    }



//== OTHER NON-PRIVATE INSTANCE METHODS ========================================

    /***************************************************************************
     * Binární operace nad prvky grupy, která splňuje pravidla teorie grup.
     *
     * @param second pravý operand
     * @return Výsledek operace
     */
    @Override
    public DirectionGroup operation(DirectionGroup second)
    {
        Direction8 argument = second.direction;
        return operation(argument);
    }


    /***************************************************************************
     * Binární operace nad prvky grupy, která splňuje pravidla teorie grup.
     *
     * @param second pravý operand
     * @return Výsledek operace
     */
    @Override
    public DirectionGroup operation(Direction8 second)
    {
        int index1 = this  .direction.ordinal();
        int index2 = second          .ordinal();
        int index  = index1 + index2;
        Direction8 result = Direction8.get(index);
        return new DirectionGroup(result);
    }


    /***************************************************************************
     * Textový podpis instance - použije se název sdruženého směru.
     *
     * @return Textový podpis
     */
    @Override
    public String toString()
    {
        return direction.toString();
    }



//== PRIVATE AND AUXILIARY INSTANCE METHODS ====================================



//##############################################################################
//== NESTED DATA TYPES =========================================================
}
