package b72_j21ref.c22_generics;
/* M:/72_Java/b72_j21ref/c22_generics/package-info.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */


/*******************************************************************************
 * Instance interfejsu {@code IGroup} představují prvky grupy
 * s definovanou binární operací.
 *
 * @param <B> Bázový typ, nad nímž je grupa vystavena
 * @param <G> Typ prvků konkrétní grupy
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public interface IGroup<B, G extends IGroup<B, G>>
{
//== STATIC CONSTANTS ==========================================================
//== STATIC METHODS ============================================================



//##############################################################################
//== ABSTRACT GETTERS AND SETTERS ==============================================

    /***************************************************************************
     * Vrátí sdružený prvek bázového typu odpovídající danému grupovému prvku.
     *
     * @return Sdružený prvek
     */
    public B getBaseElement();


    /***************************************************************************
     * Vrátí inverzní prvek k danému prvku.
     *
     * @return Inverzní prvek
     */
    public G getInverseElement();


    /***************************************************************************
     * Vrátí neutrální prvek dané grupy.
     *
     * @return Neutrální prvek
     */
    public G getIdentityElement();



//== OTHER ABSTRACT METHODS ====================================================

    /***************************************************************************
     * Binární operace nad prvky grupy, která splňuje pravidla teorie grup.
     *
     * @param second pravý operand
     * @return Výsledek operace
     */
//    @Override
    public G operation(B second);


    /***************************************************************************
     * Binární operace nad prvky grupy, která splňuje pravidla teorie grup.
     *
     * @param second pravý operand
     * @return Výsledek operace
     */
//    @Override
    public G operation(G second);



//== DEFAULT GETTERS AND SETTERS ===============================================
//== OTHER DEFAULT METHODS =====================================================



//##############################################################################
//== NESTED DATA TYPES =========================================================
}
