package b72_j21ref.c22_generics;
/* M:/72_Java/b72_j21ref/c22_generics/package-info.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */

import ruplib.canvasmanager.Ellipse;
import ruplib.canvasmanager.Rectangle;

import ruplib.util.NamedColor;



/*******************************************************************************
 * ITovární třída {@code ObjectMethods} slouží k porovnání
 * se třídou {@link GenericMethods}.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class ObjectMethods
{
//== CONSTANT CLASS ATTRIBUTES =================================================
//== VARIABLE CLASS ATTRIBUTES =================================================

//== STATIC INITIALIZER (CLASS CONSTRUCTOR) ====================================
//== CLASS GETTERS AND SETTERS =================================================
//== OTHER NON-PRIVATE CLASS METHODS ===========================================

    /***************************************************************************
     * Zkopíruje hodnoty uložené v jedné přepravce do druhé přepravky,
     * tj.přiřadí atributům parametru {@code dest}
     * hodnoty atributů parametru {@code source}.
     *
     * Tato verze nepoužívá typové parametry,
     * takže překladač nemůže kontrolovat, že uživatel neudělal omylem chybu.
     * @param dest   Cílová přepravka do níž se hodnoty ukládají
     * @param source Zdrojová přepravka, odkud se hodnoty berou
     */
    public static void assignContent(ObjectCrate2 dest,
                                     ObjectCrate2 source)
    {
        System.out.println("Do proměnné: " + dest +
                           "  přiřadíme: " + source);
        dest.setV1(source.getV1());
        dest.setV2(source.getV2());
        System.out.println("   výsledek: " + dest);
    }



//== PRIVATE AND AUXILIARY CLASS METHODS =======================================



//##############################################################################
//== CONSTANT INSTANCE ATTRIBUTES ==============================================
//== VARIABLE INSTANCE ATTRIBUTES ==============================================



//##############################################################################
//== CONSTRUCTORS AND FACTORY METHODS ==========================================

    /***************************************************************************
     *
     */
    public ObjectMethods()
    {
    }



//== ABSTRACT METHODS ==========================================================
//== INSTANCE GETTERS AND SETTERS ==============================================
//== OTHER NON-PRIVATE INSTANCE METHODS ========================================
//== PRIVATE AND AUXILIARY INSTANCE METHODS ====================================



//##############################################################################
//== NESTED DATA TYPES =========================================================



//##############################################################################
//== TESTING CLASSES AND METHODS ===============================================

    /***************************************************************************
     * Demonstruje používání generických metod a jejich typových parametrů
     */
    public static void testAssignContent()
    {
        ObjectCrate2 re_el_1;
        ObjectCrate2 re_el_2;
        ObjectCrate2 sh_sh_1;
        ObjectCrate2 sh_sh_2;

        Rectangle r1 = new Rectangle();
        Ellipse   e1 = new Ellipse  ();
        Rectangle r2 = new Rectangle(100, 100, 100, 100, NamedColor.SMOKY);
        Ellipse   e2 = new Ellipse  (100, 100, 100, 100, NamedColor.MILKY);

        re_el_1 = new ObjectCrate2(r1, e1);
        re_el_2 = new ObjectCrate2(r2, e2);
        re_el_2 = new ObjectCrate2(e2, r2);    //Bezostyšně špatně přiřadí
        System.out.println("Vytvořeny přepravky:\n  re_el_1=" + re_el_1 +
                                               "\n  re_el_2=" + re_el_2);

        assignContent(re_el_2, re_el_1);
        System.out.println("Po přiřazení:\n  re_el_1=" + re_el_1);

        sh_sh_1 = new ObjectCrate2(r1, e1);    //Nemá problém
        System.out.println("Po druhém přiřazení:\n  re_el_2=" + re_el_1);

        sh_sh_1 = new ObjectCrate2(r1, e2);
        sh_sh_2 = new ObjectCrate2(r2, e2);
        System.out.println("Vytvořeny přepravky:\n  sh_sh_1=" + sh_sh_1 +
                                               "\n  sh_sh_2 " + sh_sh_2);
        assignContent(sh_sh_2, sh_sh_1);
        System.out.println("Po třetím přiřazení:\n  sh_sh_1=" + sh_sh_1);

        assignContent(sh_sh_1, re_el_1);    //Opět nemá problém
        System.out.println("Po čtvrtém přiřazení:\n  sh_sh_1=" + sh_sh_1);

        sh_sh_2 = new ObjectCrate2(r1, e2);
        System.out.println("Vytvořena přepravka:\n  sh_sh_1=" + sh_sh_1);

        //Volání statické metody s kvalifikací
        ObjectMethods.assignContent(sh_sh_1, sh_sh_2);
        System.out.println("Po přiřazení:\n  sh_sh_1=" + sh_sh_1);
    }


    /***************************************************************************
     * Hlavní metoda spouštějící celou aplikaci
     *
     * @param args Parametry příkazového řádku - zde nepoužité.
     */
    public static void main(String[] args)
    {
        testAssignContent();
    }

}
