package b72_j21ref.c22_generics;
/* M:/72_Java/b72_j21ref/c22_generics/package-info.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */


public class ThrowsTypeArgument<T extends Throwable>
{
    Class<T> excClass;

    public ThrowsTypeArgument(Class<T> excClass) {
        this.excClass = excClass;
        System.err.println("Vytvářím objekt s výjimkou typu " + excClass);
    }

    public void throwing()  throws T
    {
        try {
            T toThrow = excClass.getConstructor().newInstance();
            System.err.println(" - Vyhazuji výjimku " + toThrow );
            throw toThrow;
        }
        catch(Exception e) {
            throw new RuntimeException("Nepovedlo se vytvořit výjimku", e );
        }
    }

    public static <U extends Throwable> void check(ThrowsTypeArgument<U> v)
    {
        try {
            System.err.println("Volám s parametrem " + v);
            v.throwing();
            System.err.println("Operace zdárně prošla");
        }catch( Throwable t) {
            System.err.println("Operace vyhodila výjimku " + t);
            System.err.println("  Zpráva: " + t.getMessage());
        }
        System.err.println("==============");
    }

//===== TESTY =================================================================

//##############################################################################
//== MAIN METHOD ===============================================================

    /***************************************************************************
     * Metoda spouštějící celou aplikaci.
     *
     * @param args Parametry příkazového řádku
     */
    @SuppressWarnings({"unchecked", "rawtypes"})
    public static void main(String[] args)
    {
        System.err.println("==============");
        check(new ThrowsTypeArgument(Throwable.class));
        check(new ThrowsTypeArgument<Exception>(Exception.class ));
        check(new ThrowsTypeArgument<RuntimeException>(RuntimeException.class ));
    }
}
