package b72_j21ref.c23_typearguments;
/* M:/72_Java/b72_j21ref/c23_typearguments/MathT.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */


/*******************************************************************************
 * Třída {@code MathT} ja knihovní třídou poskytující
 * různé matematické a pomocné funkce nad instancemi objektových typů.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class MathT
{
//== PRIVATE AND AUXILIARY CLASS METHODS =======================================

    /***************************************************************************
     * Vrátí menší z hodnot, přesněji
     * vrátí instanci, jež je považována za "menší".
     *
     * @param <T> Typ porovnávaných objektů
     * @param t1  První z porovnávaných objektů
     * @param t2  Druhý z porovnávaných objektů
     * @return    "Menší" z porovnávaných objektů
     */
    public static <T extends Comparable<? super T>> T max(T t1, T t2)
    {
        return (t1.compareTo(t2) < 0) ? t2 : t1;
    }


    /***************************************************************************
     * Vrátí menší ze zadaných hodnot, přesněji
     * vrátí instanci, jež je považována za "větší".
     *
     * @param <T> Typ porovnávaných objektů
     * @param t1  První z porovnávaných objektů
     * @param t2  Druhý z porovnávaných objektů
     * @return    "Větší" z porovnávaných objektů
     */
    public static <T extends Comparable<? super T>> T min(T t1, T t2)
    {
        return (t1.compareTo(t2) < 0) ? t1 : t2;
    }



//##############################################################################
//== CONSTRUCTORS AND FACTORY METHODS ==========================================

    /** Soukromý konstruktor zabraňující vytvoření instance.*/
    private MathT() {}

}
