package java.lang;
/* M:/72_Java/b72_j21ref/c25_enums/Enum.javax
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.constant.ClassDesc;
import java.lang.constant.Constable;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DynamicConstantDesc;
import java.lang.invoke.MethodHandles;
import java.util.Optional;

import static java.util.Objects.requireNonNull;

/** Definice převzatá ze standardní knihovny po úpravě komentářů. */
public abstract class Enum<E extends Enum<E>>
        implements Constable, Comparable<E>, Serializable
{
    /** Název instance */
    private final String name;

    /** Vrátí název instance. */
    public final String name() {
        return name;
    }

    /** Pořadí definice dané hodnoty. */
    private final int ordinal;

    /** Vrátí pořadí definice dané hodnoty. */
    public final int ordinal() {
        return ordinal;
    }

    /** Konstruktor přebírající název a pořadí definice. */
    protected Enum(String name, int ordinal) {
        this.name = name;
        this.ordinal = ordinal;
    }

    /** Vrátí název instance jako její textový podpis. */
    public String toString() {
        return name;
    }

    /** Instance je ekvivalentní jen sama se sebou. */
    public final boolean equals(Object other) {
        return this==other;
    }

    /** Vrátí číselný podpis instance - její heškód. */
    public final int hashCode() {
        return super.hashCode();
    }

    /** Zabezpečí, že hodnoty nebudou klonovatelné. */
    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    /** Později definovaná instance je považována zqa větší. */
    public final int compareTo(E o) {
        Enum<?> other = o;
        Enum<E> self = this;
        if (self.getClass() != other.getClass() && // optimization
            self.getDeclaringClass() != other.getDeclaringClass())
            throw new ClassCastException();
        return self.ordinal - other.ordinal;
    }

    /** Používá se u funkčních výčtových typů. */
    @SuppressWarnings("unchecked")
    public final Class<E> getDeclaringClass() {
        Class<?> clazz = getClass();
        Class<?> zuper = clazz.getSuperclass();
        return (zuper == Enum.class) ? (Class<E>)clazz : (Class<E>)zuper;
    }

    /** Funkce zavedená v Javě 12
     *  pro použití v programech pracujících s bajtkódem. */
    @Override
    public final Optional<EnumDesc<E>> describeConstable() {
        return getDeclaringClass()
                .describeConstable()
                .map(c -> EnumDesc.of(c, name));
    }

    /** Vrátí hodnotu daného typu se zadaným názvem. */
    public static <T extends Enum<T>> T valueOf(Class<T> enumClass,
                                                String name) {
        T result = enumClass.enumConstantDirectory().get(name);
        if (result != null)
            return result;
        if (name == null)
            throw new NullPointerException("Name is null");
        throw new IllegalArgumentException(
            "No enum constant " + enumClass.getCanonicalName() + "." + name);
    }

    /** Blokace použití metody finalize(). */
    @Deprecated(since="18", forRemoval=true)
    @SuppressWarnings("removal")
    protected final void finalize() { }

    /** Blokuje implicitní deserializaci objektu. */
    @java.io.Serial
    private void readObject(ObjectInputStream in) throws IOException,
        ClassNotFoundException {
        throw new InvalidObjectException("can't deserialize enum");
    }

    /** Blokuje implicitní deserializaci objektu. */
    @java.io.Serial
    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("can't deserialize enum");
    }

    /** Třída zavedená v Javě 12
     *  pro použití v programech pracujících s bajtkódem. */
    public static final class EnumDesc<E extends Enum<E>>
            extends DynamicConstantDesc<E> {

        /** Konstruktor vytvářející popisovač pro zadanou třídu a instanci. */
        private EnumDesc(ClassDesc constantClass, String constantName) {
            super(ConstantDescs.BSM_ENUM_CONSTANT, 
                  requireNonNull(constantName), requireNonNull(constantClass));
        }

        /** Statická tovární metoda vracející objekt reprezentující
         *  hodnotu zadaného výčtového typu se zadaným názvem. */
        public static<E extends Enum<E>> EnumDesc<E> of(ClassDesc enumClass,
                                                        String constantName) {
            return new EnumDesc<>(enumClass, constantName);
        }

        /** Instanční tovární metoda vracející objekt reprezentující hodnotu
         *  zadaného výčtového typu specifikovanou zadaným popisovačem. */
        @Override
        @SuppressWarnings("unchecked")
        public E resolveConstantDesc(MethodHandles.Lookup lookup)
                throws ReflectiveOperationException {
            return Enum.valueOf(
                (Class<E>) constantType().resolveConstantDesc(lookup), 
                constantName());
        }

        /** Textový podpis instance. */
        @Override
        public String toString() {
            return String.format("EnumDesc[%s.%s]", 
                          constantType().displayName(), constantName());
        }
    }
}
