/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.canvas;

import ruplib.geom.Area;
import ruplib.geom.Position;
import ruplib.geom.Size;
import ruplib.util.IColorable;
import ruplib.util.NamedColor;



/*******************************************************************************
 * Instance třídy {@code Rectangle} představují obdélníky
 * určené pro práci na virtuálním plátně
 * při prvním seznámení s třídami a objekty.
 * Tyto obdélníky jsou definované svojí pozicí, rozměrem a barvou.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Rectangle
  implements ICanvasShape, IColorable
{
//\CC== CLASS CONSTANTS (CONSTANT CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** Počáteční barva nakreslené instance v případě,
     *  kdy uživatel žádnou požadovanou barvu nezadá -
     *  pro obdélník {@link NamedColor#RED}. */
    public static final NamedColor DEFAULT_COLOR = NamedColor.RED;

    /** Plátno, na které se bude instance kreslit. */
    private static final Canvas CANVAS;

    /** Kreslítko, jehož pomocí je možno na plátno kreslit. */
//    private static final Canvas.Painter PAINTER;



//\CV== CLASS VARIABLES (VARIABLE CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** Počet vytvořených instancí. */
    private static int count = 0;



//##############################################################################
//\CI== CLASS (STATIC) INITIALIZER (CLASS CONSTRUCTOR) =========================

    static {
        CANVAS  = Canvas.getInstance();
//        PAINTER = Canvas.Painter.getInstance();
    }



//\CF== CLASS (STATIC) FACTORY METHODS =========================================
//\CG== CLASS (STATIC) GETTERS AND SETTERS =====================================
//\CM== CLASS (STATIC) REMAINING NON-PRIVATE METHODS ===========================
//\CP== CLASS (STATIC) PRIVATE AND AUXILIARY METHODS ===========================



//##############################################################################
//\IC== INSTANCE CONSTANTS (CONSTANT INSTANCE ATTRIBUTES/FIELDS) ===============

    /** ID instance = pořadí vytvoření dané instance v rámci třídy. */
    private final int ID = ++count;

    /** Reprezentovaný grafický objekt. */
//    private final java.awt.geom.Rectangle2D.Double MODEL;



//\IV== INSTANCE VARIABLES (VARIABLE INSTANCE ATTRIBUTES/FIELDS) ===============

    /** Výchozí název instance sestavený z názvu třídy
     *  následovaného znakem podtržení a ID instance. */
    private String name = getClass().getSimpleName() + "_" + ID;

    /** The x-coordinate of the instance. */
    private int xPos;

    /** The y-coordinate of the instance. */
    private int yPos;

    /** The instance width. */
    protected int width;

    /** The instance height. */
    protected int height;

    /** Barva instance. */
    private NamedColor color;



//##############################################################################
//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ===================================

    /***************************************************************************
     * Připraví novou instanci s implicitním umístěním, rozměry a barvou.
     * Instance bude umístěna v levém horním rohu plátna
     * a bude mít implicitní barvu,
     * výšku rovnu kroku a šířku dvojnásobku kroku (tj. implicitně 50x100 bodů).
     */
    public Rectangle()
    {
        this(0, 0, 2*Canvas.getStep(), Canvas.getStep());
    }


    /***************************************************************************
     * Připraví novou instanci se zadanou pozicí a rozměry
     * a implicitní barvou.
     * Pozice instance je přitom definována jako pozice
     * jejího levého horního rohu.
     * &nbsp;
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param width   Šířka vytvářené instance, šířka &gt;= 0
     * @param height  Výška vytvářené instance, výška &gt;= 0
     */
    public Rectangle(int x, int y, int width, int height)
    {
        this(x, y, width, height, DEFAULT_COLOR);
    }


    /***************************************************************************
     * Připraví novou instanci se zadanou pozicí, rozměry a barvou.
     * Pozice instance je přitom definována jako pozice
     * jejího levého horního rohu.
     * &nbsp;
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param width   Šířka vytvářené instance,  šířka &gt; 0
     * @param height  Výška vytvářené instance,  výška &gt; 0
     * @param color   Barva vytvářené instance
     */
    public Rectangle(int x, int y, int width, int height, NamedColor color)
    {
        //Kontrola přípustnosti parametrů
        if ((width<=0) || (height<=0)  ||  (color == null)) {
            throw new IllegalArgumentException(
                "\nnew Rectangle: Parametry nemají povolené hodnoty: x=" +
                x + ", y=" + y + ", width=" + width + ", height=" + height +
                ", color=" + color);
        }

        //Parametry akceptovány, můžeme tvořit
        this.color = color;
        this.xPos  = x;
        this.yPos  = y;
        this.width = width;
        this.height= height;

        paintPrivate();
    }


    /***************************************************************************
     * Připraví novou instanci se zadanými rozměry, polohou a barvou.
     * Pozice instance je přitom definována jako pozice
     * jejího levého horního rohu.
     * &nbsp;
     *
     * @param position  Pozice vytvářené instance
     * @param size      Rozměr vytvářené instance
     * @param color     Barva vytvářené instance
     */
    public Rectangle(Position position, Size size, NamedColor color)
    {
        this(position.x, position.y, size.width, size.height, color);
    }


    /***************************************************************************
     * Připraví novou instanci vyplňující zadanou oblast
     * a mající zadanou barvu.
     * Pozice instance je přitom definována jako pozice
     * jejího levého horního rohu.
     * &nbsp;.
     *
     * @param area   Oblast definující pozici a rozměr vytvářené instance
     * @param color  Barva vytvářené instance
     */
    public Rectangle(Area area, NamedColor color)
    {
        this(area.x, area.y, area.width, area.height, color);
    }



//\IA== INSTANCE ABSTRACT METHODS ==============================================
//\IG== INSTANCE GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Vrátí aktuální barvu instance.
     *
     * @return Instance třídy {@link NamedColor}
     *         definující aktuálně nastavenou barvu
     */
    @Override
    public final NamedColor getColor()
    {
        return color;
    }


    /***************************************************************************
     * Nastaví novou barvu instance.
     *
     * @param color  Požadovaná nová barva
     */
    @Override
    public final void setColor(NamedColor color)
    {
        this.color = color;
        paint();
    }


    /***************************************************************************
     * Vrátí název instance.
     * Výchozí podoba názvu názvu sestává z názvu třídy
     * následovaného znakem podtržení a ID instance.
     * Název je ale možné kdykoliv změnit.
     *
     * @return  Název instance
     */
    public String getName()
    {
        return name;
    }


    /***************************************************************************
     * Nastaví nový název instance.
     *
     * @param name  Nový název instance
     */
    public void setName(String name)
    {
        this.name = name;
    }


    /***************************************************************************
     * Vrátí x-ovou (vodorovnou) souřadnici pozice instance,
     * tj. vodorovnou souřadnici jejího levého horního rohu
     *
     * @return  Aktuální vodorovná (x-ová) souřadnice instance,
     *          x=0 má levý okraj plátna, souřadnice roste doprava
     */
    @Override
    public int getX()
    {
        return xPos;
    }


    /***************************************************************************
     * Vrátí y-ovou (svislou) souřadnici pozice instance,
     * tj. svislou souřadnici jejího levého horního rohu.
     *
     * @return  Aktuální svislá (y-ová) souřadnice instance,
     *          y=0 má horní okraj plátna, souřadnice roste dolů
     */
    @Override
    public int getY()
    {
        return yPos;
    }


    /***************************************************************************
     * Přemístí instanci na zadanou pozici.
     * Pozice instance je přitom definována jako pozice
     * jejího levého horního rohu.
     *
     * @param x  Nově nastavovaná vodorovná (x-ová) souřadnice instance,
     *           x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y  Nově nastavovaná svislá (y-ová) souřadnice instance,
     *           y=0 má horní okraj plátna, souřadnice roste dolů
     */
    @Override
    public void setPosition(int x, int y)
    {
        rubOut();
        xPos = x;
        yPos = y;
        paint();
    }


    /***************************************************************************
     * Vrátí šířku instance v bodech.
     * Šířka instance jsou přitom definována jako šířka
     * opsaného obdélníku.
     *
     * @return  Aktuální šířka instance v bodech
     */
    @Override
    public int getWidth()
    {
        return width;
    }


    /***************************************************************************
     * Vrátí výšku instance v bodech.
     *
     * @return  Aktuální výška instance v bodech
     */
    @Override
    public int getHeight()
    {
        return height;
    }


    /***************************************************************************
     * Nastaví nové rozměry instance.
     * Rozměry instance jsou přitom definovány jako rozměry
     * opsaného obdélníku.
     * Nastavované rozměry musí být nezáporné,
     * místo nulového rozměru se nastaví rozměr rovný jedné.
     *
     * @param width    Nově nastavovaná šířka; šířka &gt;= 0
     * @param height   Nově nastavovaná výška; výška &gt;= 0
     */
    @Override
    public void setSize(int width, int height)
    {
        if ((width < 0) || (height < 0)) {
            throw new IllegalArgumentException(
//%L+ CZ
                            "\nRozměry nesmějí být záporné: width="
//%Lu EN
//                            "\nThe dimensions may not be negativ: width="
//%L-
                          + width + ", height=" + height);
        }
        rubOut();
        this.width  = width;
        this.height = height;
        paint();
    }



//\IM== INSTANCE REMAINING NON-PRIVATE METHODS =================================

    /***************************************************************************
     * Vrátí kopii dané instance,
     * tj. stejně velkou a stejně umístěnou instanci stejné barvy.
     *
     * @return Požadovaná kopie
     */
    @Override
    public Rectangle copy()
    {
        if (this instanceof ICanvasShape) {
            return new Rectangle(xPos, yPos, width, height, color);
        }
        else {
            //Pomocná třída zabezpečující správnou funkci i v případě,
            //kdy třída nebude implementovat rozhraní ICanvasShape
            class TT extends Rectangle implements ICanvasShape {
                TT(int x, int y, int s, int v, NamedColor b) {
                    super(x, y, s, v, b);
                }
            }
            return new TT(xPos, yPos, width, height, color);
        }
    }


    /***************************************************************************
     * Vrátí textový podpis instance, tj. její řetězcovou reprezentaci.
     * Používá se především při ladění.
     *
     * @return Název instance následovaný jejími souřadnicemi,
     *         rozměry a barvou
     */
    @Override
    public String toString()
    {
        return name + "[x=" + xPos + ", y=" + yPos
             + ", width=" + width + ", height=" + height
             + ", color=" + color + "]";
    }


    /***************************************************************************
     * Zobrazí svoji instanci, tj.vykreslí její obraz na plátno.
     */
    @Override
    public void paint()
    {
        paintPrivate();
    }


    /***************************************************************************
     * Smaže obraz své instance z plátna (nakreslí ji barvou pozadí plátna).
     */
    @Override
    public final void rubOut()
    {
        CANVAS.erase(new java.awt.geom.Rectangle2D.Double
                         (xPos, yPos, width, height));
    }



//\IP== INSTANCE PRIVATE AND AUXILIARY METHODS =================================

    /***************************************************************************
     * Vykreslí obraz své instance na plátno.
     * Je definována proto, aby umožnila korektní provedení operace
     * v konstruktoru, přestože metoda {@link #paint()} je virtuální.
     */
    private void paintPrivate()
    {
        CANVAS.fill(new java.awt.geom.Rectangle2D.Double
                         (xPos, yPos, width, height),
                    color);
    }



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
