/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.canvasmanager;

import ruplib.geom.AShape;
import ruplib.geom.Area;
import ruplib.geom.Position;
import ruplib.geom.Size;
import ruplib.util.IColorable;
import ruplib.util.NamedColor;



/*******************************************************************************
 * Instance třídy {@code Elipsa} představují elipsy
 * určené pro práci na plátně spravovaném správcem plátna &ndash;.
 * instancí třídy {@link CanvasManager}.
 * Tyto elipsy jsou definované svojí pozicí, rozměrem a barvou.
 * Pozicí instance se přitom rozumí
 * pozice levého horního rohu opsaného obdélníku
 * a rozměrem instance se rozumí rozměr tohoto obdélníku.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Ellipse
     extends AShape
  implements ICMShape, IColorable
{
//\CC== CLASS CONSTANTS (CONSTANT CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** Počáteční barva nakreslené instance v případě,
     *  kdy uživatel žádnou požadovanou barvu nezadá -
     *  pro elipsu {@link NamedColor#BLUE}. */
    public static final NamedColor DEFAULT_COLOR = NamedColor.BLUE;



//\CV== CLASS VARIABLES (VARIABLE CLASS/STATIC ATTRIBUTES/FIELDS) ==============



//##############################################################################
//\CI== CLASS (STATIC) INITIALIZER (CLASS CONSTRUCTOR) =========================
//\CF== CLASS (STATIC) FACTORY METHODS =========================================
//\CG== CLASS (STATIC) GETTERS AND SETTERS =====================================
//\CM== CLASS (STATIC) REMAINING NON-PRIVATE METHODS ===========================
//\CP== CLASS (STATIC) PRIVATE AND AUXILIARY METHODS ===========================



//##############################################################################
//\IC== INSTANCE CONSTANTS (CONSTANT INSTANCE ATTRIBUTES/FIELDS) ===============
//\IV== INSTANCE VARIABLES (VARIABLE INSTANCE ATTRIBUTES/FIELDS) ===============

    /** Barva instance. */
    private NamedColor color;



//##############################################################################
//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ===================================

    /***************************************************************************
     * Připraví novou instanci s implicitním umístěním, rozměry a barvou.
     * Instance bude umístěna v levém horním rohu plátna
     * a bude mít implicitní barvu,
     * výšku rovnu kroku a šířku dvojnásobku kroku (tj. implicitně 50x100 bodů).
     */
    public Ellipse()
    {
        this(0, 0, 2*CM.getStep(), CM.getStep());
    }


    /***************************************************************************
     * Připraví novou instanci se zadanou pozicí a rozměry
     * a implicitní barvou.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku,
     * a rozměr instance jako rozměr tohoto obdélníku.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param width   Šířka vytvářené instance, šířka &gt;= 0
     * @param height  Výška vytvářené instance, výška &gt;= 0
     */
    public Ellipse(int x, int y, int width, int height)
    {
        this(x, y, width, height, DEFAULT_COLOR);
    }


    /***************************************************************************
     * Připraví novou instanci se zadanou pozicí, rozměry a barvou.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku,
     * a rozměr instance jako rozměr tohoto obdélníku.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param width   Šířka vytvářené instance, šířka &gt;= 0
     * @param height  Výška vytvářené instance, výška &gt;= 0
     * @param color   Barva vytvářené instance
     */
    public Ellipse(int x, int y, int width, int height, NamedColor color)
    {
        super(x, y, width, height);
        this.color = color;
    }


    /***************************************************************************
     * Připraví novou instanci se zadanými rozměry, polohou a barvou.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku,
     * a rozměr instance jako rozměr tohoto obdélníku.
     *
     * @param position  Pozice vytvářené instance
     * @param size      Rozměr vytvářené instance
     * @param color     Barva vytvářené instance
     */
    public Ellipse(Position position, Size size, NamedColor color)
    {
        this(position.x, position.y, size.width, size.height, color);
    }


    /***************************************************************************
     * Připraví novou instanci vyplňující zadanou oblast
     * a mající zadanou barvu.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku,
     * a rozměr instance jako rozměr tohoto obdélníku.
     *
     * @param area  Oblast definující pozici a rozměr vytvářené instance
     * @param color Barva vytvářené instance
     */
    public Ellipse(Area area, NamedColor color)
    {
        this(area.x, area.y, area.width, area.height, color);
    }



//\IA== INSTANCE ABSTRACT METHODS ==============================================
//\IG== INSTANCE GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Vrátí aktuální barvu instance.
     *
     * @return Instance třídy {@link NamedColor} definující
     *         aktuálně nastavenou barvu
     */
    @Override
    public final NamedColor getColor()
    {
        return color;
    }


    /***************************************************************************
     * Nastaví novou barvu instance.
     *
     * @param color  Požadovaná nová barva
     */
    @Override
    public final void setColor(NamedColor color)
    {
        this.color = color;
        CM.repaint();
    }


    /***************************************************************************
     * Přemístí instanci na zadanou pozici.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku.
     *
     * @param x  Nově nastavovaná vodorovná (x-ová) souřadnice instance,
     *           x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y  Nově nastavovaná svislá (y-ová) souřadnice instance,
     *           y=0 má horní okraj plátna, souřadnice roste dolů
     */
    @Override
    public void setPosition(int x, int y)
    {
        CM.changeTogether(() -> super.setPosition(x, y));
    }


    /***************************************************************************
     * Nastaví nové rozměry instance.
     * Rozměry instance jsou přitom definovány jako rozměry
     * opsaného obdélníku.
     * Nastavované rozměry musí být nezáporné,
     * místo nulového rozměru se nastaví rozměr rovný jedné.
     *
     * @param width    Nově nastavovaná šířka; šířka &gt;= 0
     * @param height   Nově nastavovaná výška; výška &gt;= 0
     */
    @Override
    public void setSize(int width, int height)
    {
        CM.changeTogether(() -> super.setSize(width, height));
    }



//\IM== INSTANCE REMAINING NON-PRIVATE METHODS =================================

    /***************************************************************************
     * Vrátí kopii dané instance,
     * tj. stejně velkou a stejně umístěnou instanci stejné barvy.
     *
     * @return Požadovaná kopie
     */
    @Override
    public Ellipse copy()
    {
        return new Ellipse(getX(), getY(), getWidth(), getHeight(), color);
    }


    /***************************************************************************
     * Prostřednictvím zadaného kreslítka vykreslí obraz instance na plátno.
     *
     * @param painter Kreslítko schopné nakreslit instanci
     */
    @Override
    public void paint(Painter painter)
    {
        painter.fillEllipse(getX(), getY(), getWidth(), getHeight(), color);
    }


    /***************************************************************************
     * Vrací charakteristiky dané instance do jejího podpisu.
     *
     * @return String s charakteristikami dané instance
     */
    @Override
    protected String forToString()
    {
        return super.forToString() + ", color=" + color;
    }



//\IP== INSTANCE PRIVATE AND AUXILIARY METHODS =================================



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
