/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.canvasmanager;



/*******************************************************************************
 * Rozhraní {@code IAdaptable} je určeno pro instance, které chtějí být schopny
 * reagovat na velikosti kroku (a tím i políčka) plátna po svém.
 * Kdykoliv se změní velikost pole aktivního plátna, správce plátna to oznámí
 * všem přihlášeným přizpůsobivým ({@code IAdaptable}) objektům.
 * <p>
 * Objekt, který má reagovat na změny velikosti kroku plátna,
 * nemusí být nutně instancí tohoto interfejsu.
 * Správce plátna zabezpečí, že se změně kroku přizpůsobí i všechny instance
 * interfejsů {@link ruplib.geom.IModular},
 * {@link ruplib.geom.IChangeable} nebo
 * {@link ruplib.geom.IMovable},
 * protože jejich pozici (a jde-li to i rozměr) upraví sám.
 * Implementuje-li registrovaný objekt rozhraní {@code IAdaptable},
 * dostane jeho metoda {@link #stepChanged(int, int)} přednost
 * před upravovací metodou spouštěnou správcem plátna.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public interface IAdaptable extends ICMPaintable
{
//\CC== CLASS (STATIC) CONSTANTS ===============================================
//\CM== CLASS (STATIC) METHODS =================================================



//##############################################################################
//\AG== ABSTRACT GETTERS AND SETTERS ===========================================
//\AM== REMAINING ABSTRACT METHODS =============================================

    /***************************************************************************
     * Změní bodovou pozici a rozměr instance v závislosti na zadané změně
     * kroku plátna tak, aby se nezměnila jeho políčková pozice a velikost.
     *
     * @param oldStep  Původní velikost kroku
     * @param newStep  Nově nastavená velikost kroku
     */
//    @Override
    public void stepChanged(int oldStep, int newStep);



//\DG== DEFAULT GETTERS AND SETTERS ============================================
//\DM== REMAINING DEFAULT METHODS ==============================================



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
