/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.canvasmanager;

import ruplib.geom.IMovable;
import ruplib.util.ICopyable;
import ruplib.geom.Position;
import ruplib.util.IColorable;
import ruplib.util.NamedColor;
import java.awt.Font;



/*******************************************************************************
 * Instance třídy {@code Text}.reprezentují texty
 * zobrazitelné na plátně spravovaném správcem plátna.
 * Jsou definovány zobrazovaným textem, jeho pozicí a barvou.
 * Pozicí instance se přitom rozumí
 * pozice levého horního rohu opsaného obdélníku.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Text
  implements IMovable, ICopyable, IColorable, ICMPaintable
{
//\CC== CLASS CONSTANTS (CONSTANT CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** Konstanta označující text vysazený netučným, nekurzivním písmem. */
    public static final int PLAIN = Font.PLAIN;

    /** Konstanta označující text vysazený tučným, nekurzivním písmem. */
    public static final int BOLD    = Font.BOLD;

    /** Konstanta označující text vysazený netučným, kurzivním písmem. */
    public static final int ITALIC  = Font.ITALIC;

    /** Počáteční barva nakreslené instance v případě,
     *  kdy uživatel žádnou požadovanou barvu nezadá -
     *  pro text {@link NamedColor#BLACK}. */
    public static final NamedColor DEFAULT_COLOR = NamedColor.BLACK;



//\CV== CLASS VARIABLES (VARIABLE CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** Počet vytvořených instancí. */
    private static int count = 0;



//##############################################################################
//\CI== CLASS (STATIC) INITIALIZER (CLASS CONSTRUCTOR) =========================
//\CF== CLASS (STATIC) FACTORY METHODS =========================================
//\CG== CLASS (STATIC) GETTERS AND SETTERS =====================================
//\CM== CLASS (STATIC) REMAINING NON-PRIVATE METHODS ===========================
//\CP== CLASS (STATIC) PRIVATE AND AUXILIARY METHODS ===========================



//##############################################################################
//\IC== INSTANCE CONSTANTS (CONSTANT INSTANCE ATTRIBUTES/FIELDS) ===============

    /** ID instance = pořadí vytvoření dané instance v rámci třídy. */
    private final int ID = ++count;

    /** Reprezentovaný text. */
    private final String text;



//\IV== INSTANCE VARIABLES (VARIABLE INSTANCE ATTRIBUTES/FIELDS) ===============

    /** The name of the instance. The default name is constructed
     *  from simple class name followed by the instance ID,
     *  however, this name can be changed anytime in the future. */
    private String name = "Text_" + ID;

    /** Vodorovná (x-ová) bodová souřadnice instance. */
    private int xPos;

    /** Svislá (y-ová) bodová souřadnice instance. */
    private int yPos;

    /** Barva instance. */
    private NamedColor color;

    /** Písmo, jímž se zobrazuje reprezentovaný text. */
    private Font font;

    /** Font nastavený krelítku. */
    private Font painterFont;



//##############################################################################
//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ===================================

    /***************************************************************************
     * Připraví novou instanci s implicitním umístěním a barvou.
     * Instance bude umístěna v levém horním rohu plátna
     * a bude mít implicitní barvu,
     * a vysazena implicitním písmem (tučným 12bodovým písmem Dialog).
     *
     * @param text  Vypisovaný text
     */
    public Text(String text)
    {
        this(text, 0, 0);
    }


    /***************************************************************************
     * Připraví novou instanci se zadanou pozicí a implicitní barvou
     * vysazovanou implicitním písmem (tučným 12bodovým písmem Dialog).
     *
     * @param text Vypisovaný text
     * @param x    Vodorovná (x-ová) souřadnice instance,
     *             x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y    Svislá (y-ová) souřadnice instance,
     *             y=0 má horní okraj plátna, souřadnice roste dolů
     */
    public Text(String text, int x, int y)
    {
        this(x, y, DEFAULT_COLOR, text);
    }


    /***************************************************************************
     * Vytvoří novou instanci se zadanou pozicí a implicitní barvou
     * vysazena implicitním písmem (tučným 12bodovým písmem Dialog).
     *
     * @param x    Vodorovná (x-ová) souřadnice instance,
     *             x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y    Svislá (y-ová) souřadnice instance,
     *             y=0 má horní okraj plátna, souřadnice roste dolů
     * @param text Vypisovaný text
     */
    public Text(int x, int y, String text)
    {
        this(x, y, DEFAULT_COLOR, text);
    }


    /***************************************************************************
     * Vytvoří novou instanci se zadanou polohou, implicitní barvou
     * a implicitním písmem (bude vysazen tučným 12bodovým písmem Dialog).
     *
     * @param position  Pozice vytvářené instance
     * @param text      Vypisovaný text
     */
    public Text(Position position, String text)
    {
        this(position.x, position.y, text);
    }


    /***************************************************************************
     * Připraví novou instanci se zadanou pozicí a barvou.
     *
     * @param position  Pozice vytvářené instance
     * @param color     Barva vytvářené instance
     * @param text      Vypisovaný text
     */
    public Text(Position position, NamedColor color, String text)
    {
        this(position.x, position.y, color, text);
    }


    /***************************************************************************
     * Vytvoří novou instanci se zadanou pozicí a barvou.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param color   Barva vytvářené instance
     * @param text    Vypisovaný text
     */
    public Text(int x, int y, NamedColor color, String text)
    {
        this.xPos  = x;
        this.yPos  = y;
        this.text  = text;
        this.color = color;
        this.font  = new Font("Dialog", Font.BOLD, 12);
    }



//\IA== INSTANCE ABSTRACT METHODS ==============================================
//\IG== INSTANCE GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Vrátí aktuální barvu instance.
     *
     * @return Aktuální barva instance
     */
    @Override
    public NamedColor getColor()
    {
        return color;
    }


    /***************************************************************************
     * Nastaví novou barvu instance.
     *
     * @param color  Požadovaná nová barva
     */
    @Override
    public void setColor(NamedColor color)
    {
        this.color = color;
        CM.repaint();
    }


    /***************************************************************************
     * Vrátí název instance, tj. zobrazovaný text.
     *
     * @return  Název instance =  zobrazovaný text
     */
    public String getName()
    {
        return text;
    }


    /***************************************************************************
     * Vrátí font, kterým se bude daný text sázet.
     *
     * @return Požadovaný font
     */
    public Font getFont()
    {
        return font;
    }


    /***************************************************************************
     * Nastaví font, kterým se bude daný text sázet.
     *
     * @param name  Název fontu - je možno zadat jeden z názvů:
     *              "Dialog", "DialogInput", "Monospaced",
     *              "Serif",  "SansSerif".
     * @param style Je možno zadat některý z řezů:
     *              Text.PLAIN, Text.BOLD, Text.ITALIC,
     *              případně Text.BOLD|Text.ITALIC
     * @param size  Velikost písma v bodech.
     */
    public void setFont(String name, int style, int size)
    {
        font = new Font(name, style, size);
    }


    /***************************************************************************
     * Vrátí x-ovou (vodorovnou) souřadnici pozice instance,
     * tj. vodorovnou souřadnici levého horního rohu opsaného obdélníku.
     *
     * @return  Aktuální vodorovná (x-ová) souřadnice instance,
     *          x=0 má levý okraj plátna, souřadnice roste doprava
     */
    @Override
    public int getX()
    {
        return xPos;
    }


    /***************************************************************************
     * Vrátí y-ovou (svislou) souřadnici pozice instance,
     * tj. svislou souřadnici levého horního rohu opsaného obdélníku.
     *
     * @return  Aktuální svislá (y-ová) souřadnice instance,
     *          y=0 má horní okraj plátna, souřadnice roste dolů
     */
    @Override
    public int getY()
    {
        return yPos;
    }


    /***************************************************************************
     * Přemístí instanci na zadanou pozici.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku.
     *
     * @param x  Nově nastavovaná vodorovná (x-ová) souřadnice instance,
     *           x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y  Nově nastavovaná svislá (y-ová) souřadnice instance,
     *           y=0 má horní okraj plátna, souřadnice roste dolů
     */
    @Override
    public void setPosition(int x, int y)
    {
        xPos = x;
        yPos = y;
        CM.repaint();
    }



//\IM== INSTANCE REMAINING NON-PRIVATE METHODS =================================

    /***************************************************************************
     * Vrátí kopii dané instance, tj. instance zobrazující stejný text
     * se stejnou velikostí, pozicí i barvou.
     *
     * @return Požadovaná kopie
     */
    @Override
    public Text copy()
    {
        Text ret = new Text(xPos, yPos, color, name);
        ret.font        = font;
        ret.painterFont = painterFont;
        return ret;
    }


    /***************************************************************************
     * Prostřednictvím zadaného kreslítka vykreslí obraz instance na plátno.
     *
     * @param painter Kreslítko schopné nakreslit instanci
     */
    @Override
    public void paint(Painter painter)
    {
        if (font != painterFont) {
            painter.setFont(font);
            painterFont = font;
        }
        painter.drawText(name, xPos, yPos + font.getSize(), color);
    }


    /***************************************************************************
     * Returns the string representation of the object (object's signature).
     * It is used mainly by the debugging.
     *
     * @return Name of the instance followed by its coordinates,
     *         dimensions and color
     */
    @Override
    public String toString()
    {
        return name + "[x=" + xPos + ", y=" + yPos +
               ", color=" + color + ", font=" + font +
               ", text=" + text + "]";
    }



//\IP== INSTANCE PRIVATE AND AUXILIARY METHODS =================================



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
