/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.canvasmanager;

import ruplib.geom.AShape;
import ruplib.geom.Area;
import ruplib.geom.Position;
import ruplib.geom.Size;
import ruplib.geom.Direction8;
import ruplib.util.IColorable;
import ruplib.geom.IDirectable;
import ruplib.util.NamedColor;



/*******************************************************************************
 * Instance třídy {@code Trojúhelník} představují trojúhelníky
 * určené pro práci na plátně spravovaném správcem plátna &ndash;.
 * instancí třídy {@link CanvasManager}.
 * Instance jsou definované svojí pozicí, rozměrem, barvou a směrem.
 * Pozicí instance se přitom rozumí
 * pozice levého horního rohu opsaného obdélníku
 * a rozměrem rozměr tohoto obdélníku.
 * Směr trojúhelníku je pak definován jako směr,
 * do nějž je natočen jeho hlavní vrchol.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Triangle
     extends AShape
  implements ICMShape, IColorable, IDirectable
{
//\CC== CLASS CONSTANTS (CONSTANT CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** The default named color of created instances for the case,
     *  when the caller doesn't set any -
     *  for triangles it is {@code NamedColor.GREEN}. */
    public static final NamedColor DEFAULT_COLOR = NamedColor.GREEN;

    /** The default direction of created triangle, which means the direction
     *  to which the main vertex of the triagle is turned
     *  when user doesn't define any preferred direction. */
    public static final Direction8 DEFAULT_DIRECTION = Direction8.NORTH;



//\CV== CLASS VARIABLES (VARIABLE CLASS/STATIC ATTRIBUTES/FIELDS) ==============



//##############################################################################
//\CI== CLASS (STATIC) INITIALIZER (CLASS CONSTRUCTOR) =========================
//\CF== CLASS (STATIC) FACTORY METHODS =========================================
//\CG== CLASS (STATIC) GETTERS AND SETTERS =====================================
//\CM== CLASS (STATIC) REMAINING NON-PRIVATE METHODS ===========================
//\CP== CLASS (STATIC) PRIVATE AND AUXILIARY METHODS ===========================



//##############################################################################
//\IC== INSTANCE CONSTANTS (CONSTANT INSTANCE ATTRIBUTES/FIELDS) ===============
//\IV== INSTANCE VARIABLES (VARIABLE INSTANCE ATTRIBUTES/FIELDS) ===============

    /** Barva instance. */
    private NamedColor color;

    /** Směr, do nějž je instance natočena
     *  (je určován směrem hlavního vrcholu. */
    private Direction8 dir8;



//##############################################################################
//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ===================================

    /***************************************************************************
     * Vytvoří instanci s implicitním umístěním, rozměry, barvou
     * a natočením.
     * Instance bude umístěna v levém horním rohu plátna
     * a bude mít implicitní barvu,
     * výšku rovnu velikosti a šířku dvojnásobku velikosti pole plátna
     * a bude natočena vrcholem na sever.
     */
    public Triangle()
    {
        this(0, 0, 2*CM.getStep(), CM.getStep());
    }


    /***************************************************************************
     * Vytvoří instanci se zadanou pozicí a rozměry
     * a implicitní barvou a směrem natočení.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku,
     * a rozměr instance jako rozměr tohoto obdélníku.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param width   Šířka vytvářené instance, šířka &gt;= 0
     * @param height  Výška vytvářené instance, výška &gt;= 0
     */
    public Triangle(int x, int y, int width, int height)
    {
        this(x, y, width, height, DEFAULT_COLOR, DEFAULT_DIRECTION);
    }


    /***************************************************************************
     * Vytvoří instanci se zadanou pozicí, rozměry a barvou.
     * Směr natočení bude implicitní, tj. na sever.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku,
     * a rozměr instance jako rozměr tohoto obdélníku.
     * Směr trojúhelníku je definován jako směr,
     * do nějž má být natočen jeho hlavní vrchol.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param width   Šířka vytvářené instance, šířka &gt;= 0
     * @param height  Výška vytvářené instance, výška &gt;= 0
     * @param color   Barva vytvářené instance
     */
    public Triangle(int x, int y, int width, int height, NamedColor color)
    {
        this(x, y, width, height, color, DEFAULT_DIRECTION);
    }


    /***************************************************************************
     * Vytvoří instanci se zadanou pozicí, rozměry a směrem natočení
     * a s implicitní barvou.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku,
     * a rozměr instance jako rozměr tohoto obdélníku.
     * Směr trojúhelníku je definován jako směr,
     * do nějž má být natočen jeho hlavní vrchol.
     *
     * @param x         Vodorovná (x-ová) souřadnice instance,
     *                  x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y         Svislá (y-ová) souřadnice instance,
     *                  y=0 má horní okraj plátna, souřadnice roste dolů
     * @param width     Šířka vytvářené instance, šířka &gt;= 0
     * @param height    Výška vytvářené instance, výška &gt;= 0
     * @param direction Směr, do nějž má být natočen hlavní vrchol
     */
    public Triangle(int x, int y, int width, int height, Direction8 direction)
    {
        this(x, y, width, height, DEFAULT_COLOR, direction);
    }


    /***************************************************************************
     * Vytvoří instanci se zadanou pozicí, rozměry, barvou,
     * i směrem natočení.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku,
     * a rozměr instance jako rozměr tohoto obdélníku.
     * Směr trojúhelníku je definován jako směr,
     * do nějž má být natočen jeho hlavní vrchol.
     *
     * @param x         Vodorovná (x-ová) souřadnice instance,
     *                  x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y         Svislá (y-ová) souřadnice instance,
     *                  y=0 má horní okraj plátna, souřadnice roste dolů
     * @param width     Šířka vytvářené instance, šířka &gt;= 0
     * @param height    Výška vytvářené instance, výška &gt;= 0
     * @param color     Barva vytvářené instance
     * @param direction Směr, do nějž má být natočen hlavní vrchol
     */
    public Triangle(int x, int y, int width, int height,
                    NamedColor color, Direction8 direction)
    {
        super(x, y, width, height);
        if (direction==Direction8.NOWHERE) {
            throw new IllegalArgumentException(
                "\nnew Triangle: Trojúhelník musí mít zadaný existující směr");
        }
        this.color = color;
        this.dir8  = direction;
    }


    /***************************************************************************
     * Vytvoří instanci se zadanou pozicí, rozměry, barvou,
     * i směrem natočení.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku,
     * a rozměr instance jako rozměr tohoto obdélníku.
     * Směr trojúhelníku je definován jako směr,
     * do nějž má být natočen jeho hlavní vrchol.
     *
     * @param position  Pozice vytvářené instance
     * @param size      Rozměr vytvářené instance
     * @param color     Barva vytvářené instance
     * @param direction Směr, do nějž má být natočen hlavní vrchol
     */
    public Triangle(Position position, Size size, NamedColor color,
                                                  Direction8 direction)
    {
        this(position.x, position.y, size.width, size.height, color, direction);
    }


    /***************************************************************************
     * Vytvoří instanci vyplňující zadanou oblast
     * a mající zadanou barvu a směr natočení.
     * Směr trojúhelníku je definován jako směr,
     * do nějž má být natočen jeho hlavní vrchol.
     *
     * @param area      Oblast, kterou má vytvářená instance zaujmout
     * @param color     Barva vytvářené instance
     * @param direction Směr, do nějž má být natočen hlavní vrchol
     */
    public Triangle(Area area, NamedColor color, Direction8 direction)
    {
        this(area.x, area.y, area.width, area.height, color, direction);
    }



//\IA== INSTANCE ABSTRACT METHODS ==============================================
//\IG== INSTANCE GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Vrátí aktuální barvu instance.
     *
     * @return Instance třídy {@link NamedColor} definující
     *         aktuálně nastavenou barvu
     */
    @Override
    public final NamedColor getColor()
    {
        return color;
    }


    /***************************************************************************
     * Nastaví novou barvu instance.
     *
     * @param color  Požadovaná nová barva
     */
    @Override
    public final void setColor(NamedColor color)
    {
        this.color = color;
        CM.repaint();
    }


    /***************************************************************************
     * Vrátí směr, do nějž je instance otočena.
     * Směr trojúhelníku je definován jako směr,
     * do nějž je natočen jeho hlavní vrchol.
     *
     * @return  Instance třídy {@code Direction8} definující
     *          aktuálně nastavený směr
     */
    @Override
    public Direction8 getDirection()
    {
        return dir8;
    }


    /***************************************************************************
     * Otočí instanci do zadaného směru.
     * Směr trojúhelníku je definován jako směr,
     * do nějž je natočen jeho hlavní vrchol.
     *
     * @param direction Nastavovaný směr
     */
    @Override
    public void setDirection(Direction8 direction)
    {
        assert (direction != Direction8.NOWHERE)
             : "Trojúhelník musí být natočen do některého z řádných směrů";
        dir8 = direction;
        CM.repaint();
    }


    /***************************************************************************
     * Přemístí instanci na zadanou pozici.
     * Pozice instance je přitom definována jako pozice
     * levého horního rohu opsaného obdélníku.
     *
     * @param x  Nově nastavovaná vodorovná (x-ová) souřadnice instance,
     *           x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y  Nově nastavovaná svislá (y-ová) souřadnice instance,
     *           y=0 má horní okraj plátna, souřadnice roste dolů
     */
    @Override
    public void setPosition(int x, int y)
    {
        CM.changeTogether(() -> super.setPosition(x, y));
    }


    /***************************************************************************
     * Nastaví nové rozměry instance.
     * Rozměry instance jsou přitom definovány jako rozměry
     * opsaného obdélníku.
     * Nastavované rozměry musí být nezáporné,
     * místo nulového rozměru se nastaví rozměr rovný jedné.
     *
     * @param width    Nově nastavovaná šířka; šířka &gt;= 0
     * @param height   Nově nastavovaná výška; výška &gt;= 0
     */
    @Override
    public void setSize(int width, int height)
    {
        CM.changeTogether(() -> super.setSize(width, height));
    }



//\IM== INSTANCE REMAINING NON-PRIVATE METHODS =================================

    /***************************************************************************
     * Vrátí kopii dané instance,
     * tj. stejně velkou, umístěnou a natočenou instanci stejné barvy.
     *
     * @return Požadovaná kopie
     */
    @Override
    public Triangle copy()
    {
        return new Triangle(getX(), getY(), getWidth(), getHeight(), color,
                            dir8);
    }


    /***************************************************************************
     * Prostřednictvím dodaného kreslítka vykreslí obraz své instance.
     *
     * @param painter Kreslítko schopné kreslit na plátno ovládané správcem
     */
    @Override
    public void paint(Painter painter)
    {
        int[][] points = getVertexes();
        painter.fillPolygon(points[0], points[1], color);
    }


    /***************************************************************************
     * Vrací charakteristiky dané instance do jejího podpisu.
     *
     * @return String s charakteristikami dané instance
     */
    @Override
    protected String forToString()
    {
        return super.forToString() + ", color=" + color + ", direction=" + dir8;
    }



//\IP== INSTANCE PRIVATE AND AUXILIARY METHODS =================================

    /***************************************************************************
     * Vrátí matici se souřadnicemi vrcholů daného trojúhelníku.
     *
     * @return Požadovaná matice
     */
    private int[][] getVertexes()
    {
        int[] xpoints = null;
        int[] ypoints = null;

        switch(dir8)
        {
            case EAST:
                xpoints = new int[]{ getX(),
                                     getX() + getWidth(),
                                     getX() };
                ypoints = new int[]{ getY(),
                                     getY() + getHeight()/2,
                                     getY() + getHeight() };
                break;

            case NORTH_EAST:
                xpoints = new int[]{ getX(),
                                     getX() + getWidth(),
                                     getX() + getWidth() };
                ypoints = new int[]{ getY(),
                                     getY(),
                                     getY() + getHeight() };
                break;

            case NORTH:
                xpoints = new int[]{ getX(),
                                     getX() + getWidth()/2,
                                     getX() + getWidth() };
                ypoints = new int[]{ getY() + getHeight(),
                                     getY(),
                                     getY() + getHeight() };
                break;

            case NORTH_WEST:
                xpoints = new int[]{ getX(),
                                     getX(),
                                     getX() + getWidth() };
                ypoints = new int[]{ getY() + getHeight(),
                                     getY(),
                                     getY() };
                break;

            case WEST:
                xpoints = new int[]{ getX(),
                                     getX() + getWidth(),
                                     getX() + getWidth() };
                ypoints = new int[]{ getY() + getHeight()/2,
                                     getY(),
                                     getY() + getHeight() };
                break;

            case SOUTH_WEST:
                xpoints = new int[]{ getX(),
                                     getX(),
                                     getX() + getWidth() };
                ypoints = new int[]{ getY(),
                                     getY() + getHeight(),
                                     getY() + getHeight() };
                break;

            case SOUTH:
                xpoints = new int[]{ getX(),
                                     getX() + getWidth()/2,
                                     getX() + getWidth() };
                ypoints = new int[]{ getY(),
                                     getY() + getHeight(),
                                     getY() };
                break;

            case SOUTH_EAST:
                xpoints = new int[]{ getX(),
                                     getX() + getWidth(),
                                     getX() + getWidth() };
                ypoints = new int[]{ getY() + getHeight(),
                                     getY() + getHeight(),
                                     getY() };
                break;

            default:
                throw new IllegalStateException(
//%L+ CZ
                    "Instance ukazuje do nedefinovaného směru");
//%Lu EN
//                    "Instance points to a no existing direction");
//%L-
        }
        return new int[][] { xpoints, ypoints };
    }



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
