/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.geom;



////////////////////////////////////////////////////////////////////////////////
//%P-  +++++ End of ignored starting text - place for imports ++++++++++++++++++



/*******************************************************************************
 * Třída AChangeable je společnou rodičovskou třídou tříd implementujících
 * interfejs IChangeable.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public abstract class AChangeable
              extends AMovable
           implements IChangeable
{
//##############################################################################
//== VARIABLE INSTANCE FIELDS ==================================================

    /** Šířka v bodech. */
    private int width;

    /** Výška v bodech. */
    private int height;



//##############################################################################
//== CONSTRUCTORS AND FACTORY METHODS ==========================================

    /***************************************************************************
     * Vytvoří na zadaných souřadnicích instanci se zadanou šířkou a výškou.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param width   Šířka vytvářené instance,  šířka &gt;= 0
     * @param height  Výška vytvářené instance,  výška &gt;= 0
     */
    public AChangeable(int x, int y, int width, int height)
    {
        super( x, y );
        //Test platnosti parametru
        if( (width<0) || (height<0) ) {
            throw new IllegalArgumentException(
                "\n" + getClass() + "Parametry nemají povolené hodnoty: šířka="
                     + width + ", výška=" + height );
        }
        //Parametry akceptovány --> můžeme tvořit
        this.width = width;
        this.height = height;
    }



//== INSTANCE GETTERS AND SETTERS ==============================================

    /***************************************************************************
     * Vrátí šířku instance v bodech.
     *
     * @return  Aktuální šířka instance v bodech
     */
     @Override
     final public int getWidth()
     {
         return width;
     }


    /***************************************************************************
     * Vrátí výšku instance v bodech.
     *
     * @return  Aktuální výška instance v bodech
     */
     @Override
     final public int getHeight()
     {
         return height;
     }


    /***************************************************************************
     * Nastaví nové rozměry instance. Nastavované rozměry musí být nezáporné,
     * místo nulového rozměru se nastaví rozměr rovný jedné.
     *
     * @param width   Nově nastavovaná šířka; šířka &gt;= 0
     * @param height  Nově nastavovaná výška; výška &gt;= 0
     */
    @Override
    public void setSize(int width, int height)
    {
        if( (width != this.width) || (height != this.height) ) {
            if( (width < 0) || (height < 0) ) {
                throw new IllegalArgumentException(
                    "Rozměry musí byt nezáporné: šířka=" + width +
                                              ", výška=" + height );
            }
            this.width = width;
            this.height = height;
        }
    }



//== OTHER NON-PRIVATE INSTANCE METHODS ========================================

    /***************************************************************************
     * Vrací charakteristiky dané instance do jejího podpisu.
     *
     * @return Charakteristiky dané instance
     */
    @Override
    protected String forToString()
    {
        return super.forToString() +
               ", width=" + getWidth() + ", height=" + getHeight();
    }

}
