package ruplib.geom;
/* M:/72_LibSrc/ruplib/geom/ANamed.java
 * Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó
 */


/*******************************************************************************
 * Instance třídy {@code ANamed} představují ...
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public abstract class ANamed
{
//== VARIABLE CLASS FIELDS =====================================================

    /** Celkový počet vytvořených instancí. */
    private static int created = 0;



//##############################################################################
//== CONSTANT INSTANCE FIELDS ==================================================

    /** Rodné číslo instance = pořadí vytvoření dané instance v rámci třídy. */
    private final int ID;



//== VARIABLE INSTANCE FIELDS ==================================================

    /** Název instance sestávající implicitně z názvu třídy a pořadí instance */
    private String name;



//##############################################################################
//== CONSTRUCTORS AND FACTORY METHODS ==========================================

    /***************************************************************************
     * Vytvoří rodičovský podobjekt, který ihned pojmenuje.
     */
    public ANamed()
    {
        ID   = ++created;
        name = this.getClass().getSimpleName() + "_" + ID;
    }



//== INSTANCE GETTERS AND SETTERS ==============================================

    /***************************************************************************
     * Vrátí název instance, implicitně název její třídy následovaný
     * pořadím vytvoření instance v rámci instancí této třídy.
     *
     * @return  Řetězec s názvem instance
     */
    public String getName()
    {
        return name;
    }


    /***************************************************************************
     * Nastaví nový název instance.
     *
     * @param name  Řetězec s novým názvem instance
     */
    public void setName(String name)
    {
        this.name = name;
    }



//== OTHER NON-PRIVATE INSTANCE METHODS ========================================

    /***************************************************************************
     * Vrátí textový podpis instance, tj. její textovou reprezentaci.
     * Používá se především při ladění.
     *
     * @return Textová reprezentace (podpis) dané instance =
     *         název instance následovaný jejími atributy
     */
    @Override
    public String toString()
    {
        return name + "(" + forToString() + ")";
    }


    /***************************************************************************
     * Vrací charakteristiky dané instance do jejího podpisu.
     *
     * @return String s charakteristikami dané instance
     */
//    @Override
    protected String forToString()
    {
        return "";
    }

}
