/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.geom;



/*******************************************************************************
 * Instance třídy {@code Area} představují přepravky uchovávající informace
 * o pozici a rozměrech objektu.
 * Proto jsou jejich atributy deklarovány jako veřejné konstanty.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Area
{
//\CC== CLASS CONSTANTS (CONSTANT CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** Hodnota indikující, že hash-code ještě nebyl spočítán. */
    private static final int INIT_HASH_CODE = Integer.MIN_VALUE;


//\CV== CLASS VARIABLES (VARIABLE CLASS/STATIC ATTRIBUTES/FIELDS) ==============



//##############################################################################
//\CI== CLASS (STATIC) INITIALIZER (CLASS CONSTRUCTOR) =========================
//\CF== CLASS (STATIC) FACTORY METHODS =========================================
//\CG== CLASS (STATIC) GETTERS AND SETTERS =====================================
//\CM== CLASS (STATIC) REMAINING NON-PRIVATE METHODS ===========================
//\CP== CLASS (STATIC) PRIVATE AND AUXILIARY METHODS ===========================



//##############################################################################
//\IC== INSTANCE CONSTANTS (CONSTANT INSTANCE ATTRIBUTES/FIELDS) ===============

    /** Vodorovná souřadnice dané oblasti, tj. jejího levého horního rohu. */
    public final int x;

    /** Svislá souřadnice dané oblasti, tj. jejího levého horního rohu. */
    public final int y;

    /** Šířka oblasti. */
 //%Lx EN
    /** Area width. */
    public final int width;

    /** Výška oblasti. */
    public final int height;



//\IV== INSTANCE VARIABLES (VARIABLE INSTANCE ATTRIBUTES/FIELDS) ===============

    /** Jednou spočtený hash-kód se pak již pouze předává, ale už nepočítá. */
    private int hashCode = INIT_HASH_CODE;



//##############################################################################
//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ===================================

    /***************************************************************************
     * Vytvoří oblast se zadaným umístěním a rozměry.
     *
     * @param x      Vodorovná souřadnice oblasti, tj. jejího levého horního rohu
     * @param y      Svislá souřadnice oblasti, tj. jejího levého horního rohu
     * @param width  Šířka oblasti
     * @param height Výška oblasti
     */
    public Area(int x, int y, int width, int height)
    {
        this.x     = x;
        this.y     = y;
        this.width = width;
        this.height = height;
    }


    /***************************************************************************
     * Vytvoří oblast se zadaným umístěním a rozměry.
     *
     * @param position Pozice oblasti, tj. pozice jejího levého horního rohu
     * @param size     Rozměr vytvářené oblasti
     */
    public Area(Position position, Size size)
    {
        this(position.x, position.y, size.width, size.height);
    }



//\IA== INSTANCE ABSTRACT METHODS ==============================================
//\IG== INSTANCE GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Vrátí hodnotu vodorovné souřadnice oblasti.
     *
     * @return  Vodorovná souřadnice oblasti, tj. jejího levého horního rohu
     */
    public int getX()
    {
        return x;
    }


    /***************************************************************************
     * Vrátí hodnotu svislé souřadnice oblasti.
     *
     * @return  Svislá souřadnice oblasti, tj. jejího levého horního rohu
     */
    public int getY()
    {
        return y;
    }


    /***************************************************************************
     * Vrátí pozici oblasti.
     *
     * @return  Pozice oblasti, tj. jejího levého horního rohu
     */
    public Position getPosition()
    {
        return new Position (x, y);
    }


    /***************************************************************************
     * Vrátí velikost šířky oblasti.
     *
     * @return  Šířka oblasti
     */
    public int getWidth()
    {
        return width;
    }


    /***************************************************************************
     * Vrátí velikost výšky oblasti.
     *
     * @return  Výška oblasti
     */
    public int getHeight()
    {
        return height;
    }


    /***************************************************************************
     * Vrátí rozměr oblasti.
     *
     * @return  Rozměr oblasti
     */
    public Size getSize()
    {
        return new Size(width, height);
    }



//\IM== INSTANCE REMAINING NON-PRIVATE METHODS =================================

    /***************************************************************************
     * Vrátí informaci o tom, představuje-li instance zadaná v parametru
     * stejnou oblast.
     *
     * @param  object Testovaná instance
     * @return Je-li zadaná instance oblastí se stejnými hodnotami atributů,
     *         vrátí {@code true}, jinak vrátí {@code false}.
     */
    @Override
    public boolean equals(Object object)
    {
        if (! (object instanceof Area)) {
            return false;               //==========>
        }
        Area other = (Area)object;
        return (other.x     == this.x)     && (other.y      == this.y)    &&
               (other.width == this.width) && (other.height == this.height);
    }


    /***************************************************************************
     * Vrátí hash-kód dané instance.
     *
     * @return  Hash-kód
     */
    @Override
    public int hashCode()
    {
        if (hashCode == INIT_HASH_CODE) {
            hashCode = 5;
            hashCode = 31 * hashCode + this.x;
            hashCode = 31 * hashCode + this.y;
            hashCode = 31 * hashCode + this.width;
            hashCode = 31 * hashCode + this.height;
        }
        return hashCode;
    }


    /***************************************************************************
     * Vrací textovou reprezentaci (podpis) dané instance.
     * Používá se především k ladicím účelům.
     *
     * @return Podpis dané instance
     */
    @Override
    public String toString()
    {
        return "Area:[x=" + x + ", y=" + y +
               ", width=" + width + ", height=" + height + "]";
    }



//\IP== INSTANCE PRIVATE AND AUXILIARY METHODS =================================



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
