/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.geom;



/*******************************************************************************
 * Instance interfejsu {@code IChangeable} představují objekty,
 * které umějí prozradit a nastavit svoji pozici a svoje rozměry.
 * Pozice instance je implicitně definována jako pozice
 * levého horního rohu opsaného obdélníku.
 * Rozměry instance jsou přitom definovány jako rozměry opsaného obdélníku.
 * Interfejs nedeklaruje žádné nové abstraktní metody, všechny zdědí.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public interface IChangeable extends IMovable, IResizable, IFlexible
{
//\CC== CLASS (STATIC) CONSTANTS ===============================================
//\CM== CLASS (STATIC) METHODS =================================================



//##############################################################################
//\AG== ABSTRACT GETTERS AND SETTERS ===========================================
//\AM== REMAINING ABSTRACT METHODS =============================================
//\DG== DEFAULT GETTERS AND SETTERS ============================================

    /***************************************************************************
     * Vrátí instanci třídy {@code Area} s informacemi
     * o aktuální pozici a rozměrech instance.
     *
     * @return   Instance třídy {@code Area} s informacemi
     *           o aktuální pozici a rozměrech instance
     */
    default
    public Area getArea()
    {
        return new Area(getX(), getY(), getWidth(), getHeight());
    }


    /***************************************************************************
     * Nastaví novou polohu a rozměry instance prostřednictvím
     * instance třídy {@code Area}.
     *
     * @param area Nově nastavovaná oblast zaujímaná instancí
     */
    default
    public void setArea(Area area)
    {
        setArea(area.x, area.y, area.width, area.height);
    }


    /***************************************************************************
     * Nastaví pozici a rozměr objektu.
     *
     * @param position  Nově nastavovaná pozice objektu
     * @param size  Nově nastavovaný rozměr objektu
     */
    default
    public void setArea(Position position, Size size)
    {
        setArea(position.x, position.y, size.width, size.height);
    }


    /***************************************************************************
     * Nastaví novou pozici a rozměr objektu.
     * Je-li instance ve správě správce plátna, plátno se překreslí.
     *
     * @param x       Vodorovná (x-ová) souřadnice instance,
     *                x=0 má levý okraj plátna, souřadnice roste doprava
     * @param y       Svislá (y-ová) souřadnice instance,
     *                y=0 má horní okraj plátna, souřadnice roste dolů
     * @param width   Šířka vytvářeného objektu v bodech
     * @param height  Výška vytvářeného objektu v bodech
     */
    default
    public void setArea(int x, int y, int width, int height)
    {
        setPosition(x,     y   );
        setSize    (width, height);
    }



//\DM== REMAINING DEFAULT METHODS ==============================================



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
