/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.geom;



/*******************************************************************************
 * Instance rozhraní {@code ITurnable4} představují objekty,
 * které se umějí otáčet do čtyř hlavních světových stran.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public interface ITurnable4 extends IDirectable
{
//\CC== CLASS (STATIC) CONSTANTS ===============================================
//\CM== CLASS (STATIC) METHODS =================================================



//##############################################################################
//\AG== ABSTRACT GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Vrátí směr, do nějž je daná instance natočena.
     *
     * @return Směr, do nějž je daná instance natočena
     */
    @Override
    public Direction8 getDirection();



//\AM== REMAINING ABSTRACT METHODS =============================================

    /***************************************************************************
     * Otočí instanci o 90° vlevo.
     */
    public void turnLeft();


    /***************************************************************************
     * Otočí instanci o 90° vpravo.
     */
    public void turnRight();



//\DG== DEFAULT GETTERS AND SETTERS ============================================

    /***************************************************************************
     * Otočí instanci do zadaného hlavního směru.
     *
     * @param direction Směr, do nějž má být instance otočena
     * @throws RuntimeException Není-li zadaný objekt otočen do některé
     *         ze čtyř hlavních světových stran nebo jej chceme otočit
     *         jinam než do některé ze čtyř hlavních světových stran
     */
    @Override
    default public void setDirection(Direction8 direction)
    {
        direction.turnTo4(this);
    }



//\DM== REMAINING DEFAULT METHODS ==============================================

    /***************************************************************************
     * Otočí instanci o 180°.
     */
    default public void turnAbout()
    {
        turnLeft();
        turnLeft();
    }


    /***************************************************************************
     * Otočí instanci do zadaného směru.
     * Je to pouze jinak pojmenovaná metoda {@link #setDirection(Direction8) },
     * aby její název odpovídal duchu ostatních "otáčecích" metod.
     *
     * @param direction Směr, do nějž má být instance otočena
     * @throws RuntimeException Není-li zadaný objekt otočen do některé
     *         ze čtyř hlavních světových stran nebo jej chceme otočit
     *         jinam než do některé ze čtyř hlavních světových stran
     */
    default public void turnTo4(Direction8 direction)
    {
        direction.turnTo4(this);
    }



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
