/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.geom;



/*******************************************************************************
 * Instance třídy {@code Rozměr} představují přepravky uchovávající informace
 * o rozměrech objektu.
 * Proto jsou jejich atributy deklarovány jako veřejné konstanty.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Size
{
//\CC== CLASS CONSTANTS (CONSTANT CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** Hodnota indikující, že hash-code ještě nebyl spočítán. */
    private static final int INIT_HASH_CODE = Integer.MIN_VALUE;


//\CV== CLASS VARIABLES (VARIABLE CLASS/STATIC ATTRIBUTES/FIELDS) ==============



//##############################################################################
//\CI== CLASS (STATIC) INITIALIZER (CLASS CONSTRUCTOR) =========================
//\CF== CLASS (STATIC) FACTORY METHODS =========================================
//\CG== CLASS (STATIC) GETTERS AND SETTERS =====================================
//\CM== CLASS (STATIC) REMAINING NON-PRIVATE METHODS ===========================
//\CP== CLASS (STATIC) PRIVATE AND AUXILIARY METHODS ===========================



//##############################################################################
//\IC== INSTANCE CONSTANTS (CONSTANT INSTANCE ATTRIBUTES/FIELDS) ===============

    /** Šířka objektu. */
    public final int width;

    /** Výška objektu. */
    public final int height;



//\IV== INSTANCE VARIABLES (VARIABLE INSTANCE ATTRIBUTES/FIELDS) ===============

    /** Jednou spočtený hash-kód se pak již pouze předává, ale už nepočítá. */
    private int hashCode = INIT_HASH_CODE;



//##############################################################################
//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ===================================

    /***************************************************************************
     * Vytvoří přepravku uchovávající zadané rozměry.
     *
     * @param width  Šířka objektu
     * @param height Výška objektu
     */
    public Size(int width, int height)
    {
        this.width  = width;
        this.height = height;
    }



//\IA== INSTANCE ABSTRACT METHODS ==============================================
//\IG== INSTANCE GETTERS AND SETTERS ===========================================

    /***************************************************************************
     * Vrátí šířku objektu.
     *
     * @return  Šířka objektu
     */
    public int getWidth()
    {
        return width;
    }


    /***************************************************************************
     * Vrátí výšku objektu.
     *
     * @return  Výška objektu
     */
    public int getHeight()
    {
        return height;
    }



//\IM== INSTANCE REMAINING NON-PRIVATE METHODS =================================

    /***************************************************************************
     * Vrátí informaci o tom, představuje-li instance zadaná v parametru
     * stejnou pozici.
     *
     * @param  object Testovaná instance
     * @return Je-li zadaná instance pozicí se stejnými hodnotami atributů,
     *         vrátí {@code true}, jinak vrátí {@code false}.
     */
    @Override
    public boolean equals(Object object)
    {
        return (object instanceof Size)               &&
               (((Size)object).width  == this.width)  &&
               (((Size)object).height == this.height);
    }


    /***************************************************************************
     * Vrátí hash-kód dané instance.
     *
     * @return  Hash-kód
     */
    @Override
    public int hashCode()
    {
        if (hashCode == INIT_HASH_CODE) {
            hashCode = 3;
            hashCode = 37 * hashCode + this.width;
            hashCode = 37 * hashCode + this.height;
        }
        return hashCode;
    }


    /***************************************************************************
     * Vrací textovou reprezentaci (podpis) dané instance.
     * Používá se především k ladicím účelům.
     *
     * @return Podpis dané instance
     */
    @Override
    public String toString()
    {
        return "Size[width=" + width + ", height=" + height + "]";
    }



//\IP== INSTANCE PRIVATE AND AUXILIARY METHODS =================================



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
