/* Saved in UTF-8 codepage: Příliš žluťoučký kůň úpěl ďábelské ódy. ÷ × ¤
 * Check: «Stereotype», Section mark-§, Copyright-©, Alpha-α, Beta-β, Smile-☺
 */
package ruplib.util;

import java.util.Random;



/*******************************************************************************
 * Knihovní třída {@code Util} obsahuje sadu různých užitečných metod
 * zastupujících obdobné avšak složitěji volané  metody ze standardní knihovny,
 * anebo nabízejících dodatečnou funkcionalitu využitelnou v úvodních kurzech.
 *
 * @author  Rudolf PECINOVSKÝ
 * @version 2023-Summer
 */
public class Util
{
//\CC== CLASS CONSTANTS (CONSTANT CLASS/STATIC ATTRIBUTES/FIELDS) ==============

    /** Generátor náhodných čísel. */
    private static final Random RND = new Random();



//\CV== CLASS VARIABLES (VARIABLE CLASS/STATIC ATTRIBUTES/FIELDS) ==============



//##############################################################################
//\CI== CLASS (STATIC) INITIALIZER (CLASS CONSTRUCTOR) =========================
//\CF== CLASS (STATIC) FACTORY METHODS =========================================
//\CG== CLASS (STATIC) GETTERS AND SETTERS =====================================
//\CM== CLASS (STATIC) REMAINING NON-PRIVATE METHODS ===========================

    /***************************************************************************
     * Při splnění zadané podmínky otevře dialogové okno s nápisem KONEC
     * a po jeho zavření ukončí program.
     *
     * @param end Podmínka, při jejímž splnění se program ukončí
     */
    public static void endIf(boolean end)
    {
        endIf(end, null);
    }


    /***************************************************************************
     * Při splnění zadané podmínky otevře dialogové okno se zadanou zprávou
     * a po jeho zavření ukončí program.
     *
     * @param end     Podmínka, při jejímž splnění se program ukončí
     * @param message Zpráva vypisovaná v dialogovém okně. Je-li {@code null}
     *                nebo prázdný řetězec, vypíše <b>{@code KONEC}</b>.
     */
    public static void endIf(boolean end, String message)
    {
        if (end) {
            if ((message == null)  ||  (message.isEmpty())) {
                message = "END";
            }
            IO.inform(message);
            System.exit(0);
        }
    }


    /***************************************************************************
     * Vrátí pseudonáhodné celé číslo ze zadaného uzavřeného intervalu.
     *
     * @param  from Nejmenší očekávané číslo
     * @param  to   Největší očekávané číslo
     * @return Pseudonáhodné celé číslo ze zadaného uzavřeného intervalu
     */
    public static int getRandom(int from, int to)
    {
        int result = from + RND.nextInt(to - from + 1);
        return result;
    }



//\CP== CLASS (STATIC) PRIVATE AND AUXILIARY METHODS ===========================



//##############################################################################
//\IC== INSTANCE CONSTANTS (CONSTANT INSTANCE ATTRIBUTES/FIELDS) ===============
//\IV== INSTANCE VARIABLES (VARIABLE INSTANCE ATTRIBUTES/FIELDS) ===============



//##############################################################################
//\II== INSTANCE INITIALIZERS (CONSTRUCTORS) ===================================

    /***************************************************************************
     */
    public Util()
    {
    }



//\IA== INSTANCE ABSTRACT METHODS ==============================================
//\IG== INSTANCE GETTERS AND SETTERS ===========================================
//\IM== INSTANCE REMAINING NON-PRIVATE METHODS =================================
//\IP== INSTANCE PRIVATE AND AUXILIARY METHODS =================================



//##############################################################################
//\NT== NESTED DATA TYPES ======================================================
}
