/* M:/72_INP/09C_Loops.jsh
Příliš žluťoučký kůň úpěl ďábelské ó - PŘÍLIŠ ŽLUŤOUČKÝ KŮŇ ÚPĚL ĎÁBELSKÉ Ó

Příkazy a úryvky zadávané ve výpisech v kapitole:
09  Opakování části kódu
/*************************************************************************/


/*
** Výpis 9.0: Inicializace prostředí – definice pomocných metod a proměnných
********************************************************************/
/set start Start_07.jsh
/reset
/methods
/vars
/********************************************************************


/*
** Výpis 9.1:	Ukázka použití cyklu s ukončovací podmínkou
 *				(cyklu do…while) – definice metody clockTest_do()
********************************************************************/
void clockTest_do()
{
    long start = System.currentTimeMillis();
    int  loops = 0;
    long stop;

    do{
        loops++;
        stop = System.currentTimeMillis();
    }while (start == stop);

    System.out.println("Změna=" + (stop-start) +
                       " ms po " + loops + ". čtení" );
}
{clockTest_do();clockTest_do();clockTest_do();clockTest_do();}
/********************************************************************


/*
** Výpis 9.2:	Ukázka použití cyklu s počáteční podmínkou
 *				(cyklu while) – definice metody clockTest_while(int)
********************************************************************/
void clockTest_while(int attempts)
{
    int attempt = 1;
    System.out.println("===== ZAČÁTEK TESTU WHILE =====");
    while (attempt <= attempts)
    {
        System.out.print(attempt + ". pokus: ");
        clockTest_do();
        attempt++;
    }
    System.out.println("===== KONEC TESTU WHILE =====");
}
clockTest_while(10);
clockTest_while(0);
/********************************************************************


/*
** Výpis 9.3:	Ukázka použití cyklu s parametrem
 * 				(cyklu for) – definice metody clockTest_for(int)
********************************************************************/
void clockTest_for(int attempts)
{
    System.out.println("===== ZAČÁTEK TESTU FOR =====");
    for (int attempt = 1;   attempt <= attempts;   attempt++)
    {
        System.out.print(attempt + ". pokus: ");
        clockTest_do();
    }
    System.out.println("===== KONEC TESTU FOR =====");
}
{clockTest_for(0); clockTest_for(2);}
/********************************************************************


/*
** Výpis 9.4:	Definice metody variantArguments(int...)
 * 				demonstrující zpracování proměnného počtu argumentů
 * 				a klíčové vlastnosti cyklu for
********************************************************************/
void variantArguments(int... numbers)
{
    int last = numbers.length - 1;
    String reverse = "Obráceně: [";
    print("Součet čísel ");
    int sum = 0;
    for (int i=0, j=last;   j >= 0;   sum+=numbers[i], i++, j--)
    {
        print(numbers[i]);
        print((i != last)  ?  " + "  :  " = ");
        reverse += numbers[j]  +  ((j == 0)  ?  ""    :  ", " );
    }
    println(sum);
    println(reverse + ']');
}
variantArguments();
variantArguments(1, 2, 3, 4, 5);
/********************************************************************


/*
** Výpis 9.5:	Ukázka použití dvojtečkového cyklu for
********************************************************************/
void sumArguments(int... numbers)
{
    var sum = 0;
    print("Součet čísel ");
    for (var number : numbers)
    {
        sum += number;
        print(number + " + ");
    }
    println("0 = " + sum);
}
sumArguments(1, 2, 3, 4, 5);
sumArguments();
/********************************************************************


/*
** Výpis 9.6:	Zanořování cyklů, srovnání klasického a dvojtečkového cyklu for
********************************************************************/
int maxInTable0(int[][] table)  //Pracuje s dvourozměrným polem
{
    int max = Integer.MIN_VALUE;
    for (int row=0;   row < table.length;   row++) {
        for (int col=0;   col < table[row].length;   col++) {
            if (table[row][col] > max) {
                max = table[row][col];
            }
        }
    }
    return max;
}
int maxInTable1(int[][] table)  //Pracuje s polem polí
{
    int max = Integer.MIN_VALUE;
    for (int r=0;   r < table.length;   r++) {
        int[] row = table[r];
        for (int col=0;   col < row.length;   col++) {
            if (row[col] > max) {
                max = row[col];
            }
        }
    }
    return max;
}
int maxInTable2(int[][] table)  //Využívá cyklus typu foreach
{
    int max = Integer.MIN_VALUE;
    for (int[] row : table) {
        for (int i : row) {
            if (i > max) {
                max = i;
            }
        }
    }
    return max;
}
{int[][] table = {{1, 3, 5, 7, 9}, {2, 4, 6, 8}, {0}};
 println("Indexový     - max=" + maxInTable0(table));
 println("Řádkový      - max=" + maxInTable1(table));
 println("Dvojtečkový  - max=" + maxInTable2(table));}
/********************************************************************


/*
** Výpis 9.7:	Ukázka použití cyklu for s prázdným tělem
********************************************************************/
int sumOfArguments(int... numbers)
{
    var sum = 0;
    for (var i=numbers.length-1;   i >= 0;   sum+=numbers[i--]);
    return sum;
}
{println("Bez parametrů: suma=" + sumOfArguments());
 println("1 + 2 + 3 + 4 + 5 = " + sumOfArguments(1, 2, 3, 4, 5));}
int firstGreater(int level, int... numbers)
{
    int i=0, result;
    while((result = numbers[i++]) <= level);
    return result;
}
firstGreater(5, 1, 3, 5, 7, 9);
/********************************************************************


/*
** Výpis 9.8:	Definice metody endlessLoop() s nekonečným cyklem
********************************************************************/
void endlessLoop()
{
    System.out.println("===== ZAČÁTEK NEKONEČNÉHO TESTU =====");
    for(;;)
    {
        clockTest_do();
    }
//  System.out.println("===== KONEC NEKONEČNÉHO TESTU =====");
}
/********************************************************************


/*
** Výpis 9.9:	Definice metody clockTest_break(int) demonstrující
 * 				použití cyklu s podmínkou uprostřed
********************************************************************/
void clockTest_break(int duration)
{
    System.out.println("===== ZAČÁTEK TESTU =====");

    long start = System.currentTimeMillis();
    long last  = start;

    for(;;)
    {
        long now;
        int  questions = 0;
        do{
            questions++;
            now = System.currentTimeMillis();
        }while (now == last);
        int time = (int)(now - start);

        if(time >= duration) { //Podmínka testující setrvání v cyklu
            break;                   //Příkaz k ukončení cyklu
        }
        println("Čas " + time + " ms, krok=" + (now-last) +
                           " ms po " + questions + ". čtení" );
        last = now;
    }
    System.out.println("===== KONEC TESTU =====");
}
clockTest_break(50);
/********************************************************************


/*
** Výpis 9.10:	Metoda labeledBreak() demonstrující použití příkazu break s návěštím
********************************************************************/
void labeledBreak()
{
    String as[] = {"Dobře", "Všechno špatně", "Lépe"};
    for (String s : as )
    {
        println("Tělo cyklu = Start 1. bloku s parametrem. " + s);
    LABEL:
        if (s != "Špatně") {
            println("  Start 2. bloku");
            if (s != "Nedobře") {
                println("    Start 3. bloku");
                if (s == "Všechno špatně") {
                    println("      Vše je špatně - končím");
                    break LABEL;
                }
                println("    Konec 3. bloku");
            }
            println("  Konec 2. bloku");
        }
        println("Konec 1. bloku, za návěštím");
    }
}
labeledBreak();
/********************************************************************


/*
** Výpis 9.11:	Metoda labeledContinue() demonstrující funkci příkazu continue
********************************************************************/
void labeledContinue()
{
    int j = 999;
LABEL:
    for (int i=6;   i > 0;   i--)
    {
        System.out.print("FOR: " + i);
        if (i%2 == 0) {
            System.out.println(" - je sudé, beru další");
            continue;   //Nepracuje se sudými čísly
        }
        System.out.println(" === Zpracovávám");
        j = i;
        while (--j > 0) {
            System.out.print("WHILE: " + j);
            if (j%3 == 0) { //Číslo dělitelné třemi cyklus ukončí
                System.out.println(" - je dělitelné třemi, končím");
                continue LABEL;
            }
            System.out.println(" --- zpracovávám");
        }
        System.out.println("WHILE-cyklus proběhl celý");
    }
    System.out.println("Skončil FOR-cyklus, j=" + j
                      +", pokračuje DO-cyklus");
    do {
        System.out.print("DO: " + j);
        if (j%2 != 0) {
            System.out.println(" - je liché, beru další");
            continue;   //Nepracuje s lichými čísly
        }
        System.out.println(" -- zpracovávám");
    }while (j++ < 4);
    System.out.println("Skončil DO-cyklus");
}
/********************************************************************


/*
** Výpis 9.12:	Demonstrace funkce metody labeledContinue()
********************************************************************/
labeledContinue();
/********************************************************************


/*
** Výpis 9.13:	Definice metody stackOverflow(int) vedoucí k přetečení zásobníku
********************************************************************/
void stackOverflow(int i)
{
    System.out.println(i);
    stackOverflow(i+1);
}
//stackOverflow(1);
/********************************************************************


/*
** Výpis 9.14:	Definice metody factorial(int) demonstrující rekurzivní volání
********************************************************************/
long factorial(int n)
{
    return (n > 1)  ?  n * factorial(n-1)
                    :  1;
}
println("5! = " + factorial(5));
/********************************************************************


/*
** Výpis X.0: Popis
********************************************************************/
                                                               //SYNC
/* Kód je uložen v souboru:
M:/72_INP/XXX.java
*/
